/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedLongCollection;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseLongIterable;
import org.eclipse.collections.impl.list.mutable.primitive.UnmodifiableLongList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedLongList
extends AbstractSynchronizedLongCollection
implements MutableLongList {
    private static final long serialVersionUID = 1L;

    SynchronizedLongList(MutableLongList list) {
        super(list);
    }

    SynchronizedLongList(MutableLongList list, Object newLock) {
        super(list, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableLongList getMutableLongList() {
        return (MutableLongList)this.getLongCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long get(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFirst() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLast() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(long value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(long value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().lastIndexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAtIndex(int index, long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().addAtIndex(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAllAtIndex(int index, long ... source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAllAtIndex(int index, LongIterable source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long removeAtIndex(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().removeAtIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long set(int index, long element) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongList with(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongList without(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongList withAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongList withoutAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableLongList select(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableLongList reject(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableList<V> collect(LongToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableLongList sortThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().sortThis();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int binarySearch(long value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().binarySearch(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long dotProduct(LongList list) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().dotProduct(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherList) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().equals(otherList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyLongIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyLongIterableAdapter(this);
        }
    }

    @Override
    public MutableLongList asUnmodifiable() {
        return new UnmodifiableLongList(this);
    }

    @Override
    public MutableLongList asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableLongList toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            int size = this.size();
            if (size == 0) {
                return LongLists.immutable.with();
            }
            if (size == 1) {
                return LongLists.immutable.with(this.getFirst());
            }
            return LongLists.immutable.with(this.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableLongList reverseThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().reverseThis();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableLongList toReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().toReversed();
        }
    }

    @Override
    public LazyLongIterable asReversed() {
        return ReverseLongIterable.adapt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithIndex(LongIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongList().forEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectLongIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().injectIntoWithIndex(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableLongList distinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongList().distinct();
        }
    }

    @Override
    public MutableLongList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

