/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ByteIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteIntMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.ByteIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.iterator.ImmutableEmptyIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteIntSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyByteIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableByteIntEmptyMap
implements ImmutableByteIntMap,
Serializable {
    static final ImmutableByteIntMap INSTANCE = new ImmutableByteIntEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;

    ImmutableByteIntEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public int get(byte key) {
        return 0;
    }

    @Override
    public int getIfAbsent(byte key, int ifAbsent) {
        return ifAbsent;
    }

    @Override
    public int getOrThrow(byte key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(byte key) {
        return false;
    }

    @Override
    public boolean containsValue(int value) {
        return false;
    }

    @Override
    public void forEachValue(IntProcedure procedure) {
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
    }

    @Override
    public void forEachKeyValue(ByteIntProcedure procedure) {
    }

    @Override
    public LazyByteIterable keysView() {
        return LazyByteIterate.empty();
    }

    @Override
    public RichIterable<ByteIntPair> keyValuesView() {
        return LazyIterate.empty();
    }

    @Override
    public ImmutableByteIntMap select(ByteIntPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableByteIntMap reject(ByteIntPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableByteIntMap toImmutable() {
        return this;
    }

    @Override
    public IntIterator intIterator() {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    @Override
    public void forEach(IntProcedure procedure) {
    }

    @Override
    public void each(IntProcedure procedure) {
    }

    @Override
    public int count(IntPredicate predicate) {
        return 0;
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public int min() {
        throw new NoSuchElementException();
    }

    @Override
    public int max() {
        throw new NoSuchElementException();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public int[] toSortedArray() {
        return new int[0];
    }

    @Override
    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    @Override
    public ImmutableIntCollection select(IntPredicate predicate) {
        return IntLists.immutable.with();
    }

    @Override
    public ImmutableIntCollection reject(IntPredicate predicate) {
        return IntLists.immutable.with();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    @Override
    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return Lists.immutable.of();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public int[] toArray() {
        return new int[0];
    }

    @Override
    public boolean contains(int value) {
        return false;
    }

    @Override
    public boolean containsAll(int ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableIntList toList() {
        return new IntArrayList();
    }

    @Override
    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    @Override
    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public ImmutableByteIntMap newWithKeyValue(byte key, int value) {
        return new ImmutableByteIntSingletonMap(key, value);
    }

    @Override
    public ImmutableByteIntMap newWithoutKey(byte key) {
        return this;
    }

    @Override
    public ImmutableByteIntMap newWithoutAllKeys(ByteIterable keys) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(new ByteHashSet());
    }

    @Override
    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(new IntArrayList());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteIntMap)) {
            return false;
        }
        ByteIntMap map = (ByteIntMap)obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "{}";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

