/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap;

import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.util.Collection;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.ImmutableMultimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.AbstractMultimap;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImmutableMultimap<K, V, C extends ImmutableCollection<V>>
extends AbstractMultimap<K, V, C>
implements ImmutableMultimap<K, V> {
    protected final ImmutableMap<K, C> map;

    protected AbstractImmutableMultimap(MutableMap<K, C> map) {
        this(map.toImmutable());
    }

    protected AbstractImmutableMultimap(ImmutableMap<K, C> immutableMap) {
        this.map = immutableMap;
    }

    @Override
    protected ImmutableMap<K, C> getMap() {
        return this.map;
    }

    @Override
    public int size() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CountProcedure
        implements Procedure<C> {
            private static final long serialVersionUID = 1L;
            private int totalSize;

            CountProcedure() {
            }

            @Override
            public void value(C collection) {
                this.totalSize += collection.size();
            }

            public int getTotalSize() {
                return this.totalSize;
            }
        }
        CountProcedure procedure = new CountProcedure();
        this.map.forEachValue(procedure);
        return procedure.getTotalSize();
    }

    @Override
    public int sizeDistinct() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public C get(K key) {
        return (C)((ImmutableCollection)this.map.getIfAbsentWith(key, this.createCollectionBlock(), this));
    }

    @Override
    public MutableMap<K, RichIterable<V>> toMap() {
        return this.map.toMap();
    }

    @Override
    public <R extends Collection<V>> MutableMap<K, R> toMap(final Function0<R> collectionFactory) {
        final UnifiedMap result = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, C>(){

            @Override
            public void value(K key, C iterable) {
                Collection newCollection = (Collection)collectionFactory.value();
                Iterate.addAllTo(iterable, newCollection);
                result.put(key, newCollection);
            }
        });
        return result;
    }

    @Override
    public ImmutableMultimap<K, V> newWith(K key, V value) {
        MutableMultimap<K, V> mutableMultimap = this.toMutable();
        mutableMultimap.put(key, value);
        return mutableMultimap.toImmutable();
    }

    @Override
    public ImmutableMultimap<K, V> newWithout(Object key, Object value) {
        MutableMultimap mutableMultimap = this.toMutable();
        mutableMultimap.remove(key, value);
        return mutableMultimap.toImmutable();
    }

    @Override
    public ImmutableMultimap<K, V> newWithAll(K key, Iterable<? extends V> values) {
        MutableMultimap<K, ? extends V> mutableMultimap = this.toMutable();
        mutableMultimap.putAll(key, values);
        return mutableMultimap.toImmutable();
    }

    @Override
    public ImmutableMultimap<K, V> newWithoutAll(Object key) {
        MutableMultimap mutableMultimap = this.toMutable();
        mutableMultimap.removeAll(key);
        return mutableMultimap.toImmutable();
    }

    @Override
    public ImmutableMultimap<K, V> toImmutable() {
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        throw new InvalidClassException("You should be using the proxy for serialization of ImmutableMultimaps");
    }
}

