/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.procedure.checked.MultimapKeyValuesSerializingProcedure;
import org.eclipse.collections.impl.multimap.AbstractMultimap;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableMultimap<K, V, C extends MutableCollection<V>>
extends AbstractMultimap<K, V, C>
implements MutableMultimap<K, V> {
    protected MutableMap<K, C> map;
    protected int totalSize;

    protected AbstractMutableMultimap() {
        this.map = this.createMap();
    }

    protected AbstractMutableMultimap(MutableMap<K, C> newMap) {
        this.map = newMap;
    }

    protected AbstractMutableMultimap(int size) {
        this.map = this.createMapWithKeyCount(size);
    }

    protected AbstractMutableMultimap(Pair<K, V> ... pairs) {
        this(pairs.length);
        this.putAllPairs(pairs);
    }

    protected AbstractMutableMultimap(Iterable<Pair<K, V>> inputIterable) {
        this();
        for (Pair<K, V> single : inputIterable) {
            this.put(single.getOne(), single.getTwo());
        }
    }

    protected abstract MutableMap<K, C> createMap();

    protected abstract MutableMap<K, C> createMapWithKeyCount(int var1);

    @Override
    protected MutableMap<K, C> getMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    protected void incrementTotalSize() {
        ++this.totalSize;
    }

    protected void decrementTotalSize() {
        --this.totalSize;
    }

    protected void addToTotalSize(int value) {
        this.totalSize += value;
    }

    protected void subtractFromTotalSize(int value) {
        this.totalSize -= value;
    }

    protected void clearTotalSize() {
        this.totalSize = 0;
    }

    @Override
    public int sizeDistinct() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean put(K key, V value) {
        C collection = this.getIfAbsentPutCollection(key);
        if (collection.add(value)) {
            this.incrementTotalSize();
            return true;
        }
        return false;
    }

    @Override
    public boolean add(Pair<K, V> keyValuePair) {
        return this.put(keyValuePair.getOne(), keyValuePair.getTwo());
    }

    @Override
    public boolean remove(Object key, Object value) {
        MutableCollection collection = (MutableCollection)this.map.get(key);
        if (collection == null) {
            return false;
        }
        boolean changed = collection.remove(value);
        if (changed) {
            this.decrementTotalSize();
            if (collection.isEmpty()) {
                this.map.remove(key);
            }
        }
        return changed;
    }

    @Override
    public boolean putAllPairs(Pair<K, V> ... pairs) {
        boolean changed = false;
        for (Pair<K, V> pair : pairs) {
            changed |= this.put(pair.getOne(), pair.getTwo());
        }
        return changed;
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        return Iterate.notEmpty(values) && this.putAllNotEmpty(key, values);
    }

    private boolean putAllNotEmpty(K key, Iterable<? extends V> values) {
        C collection = this.getIfAbsentPutCollection(key);
        int oldSize = collection.size();
        int newSize = ((MutableCollection)Iterate.addAllTo(values, collection)).size();
        this.addToTotalSize(newSize - oldSize);
        return newSize > oldSize;
    }

    @Override
    public <KK extends K, VV extends V> boolean putAll(Multimap<KK, VV> multimap) {
        if (multimap instanceof AbstractMutableMultimap) {
            return this.putAllAbstractMutableMultimap((AbstractMutableMultimap)multimap);
        }
        return this.putAllReadOnlyMultimap(multimap);
    }

    private <KK extends K, VV extends V> boolean putAllReadOnlyMultimap(Multimap<KK, VV> multimap) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PutProcedure
        implements Procedure<Pair<KK, RichIterable<VV>>> {
            private static final long serialVersionUID = 1L;
            private boolean changed;

            PutProcedure() {
            }

            @Override
            public void value(Pair<KK, RichIterable<VV>> each) {
                this.changed |= AbstractMutableMultimap.this.putAll(each.getOne(), each.getTwo());
            }
        }
        PutProcedure putProcedure = new PutProcedure();
        multimap.keyMultiValuePairsView().forEach(putProcedure);
        return putProcedure.changed;
    }

    private <KK extends K, VV extends V> boolean putAllAbstractMutableMultimap(AbstractMutableMultimap<KK, VV, MutableCollection<VV>> other) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PutProcedure
        implements Procedure2<KK, MutableCollection<VV>> {
            private static final long serialVersionUID = 1L;
            private boolean changed;

            PutProcedure() {
            }

            @Override
            public void value(KK key, MutableCollection<VV> value) {
                this.changed |= AbstractMutableMultimap.this.putAll(key, value);
            }
        }
        PutProcedure putProcedure = new PutProcedure();
        other.map.forEachKeyValue(putProcedure);
        return putProcedure.changed;
    }

    public C replaceValues(K key, Iterable<? extends V> values) {
        if (Iterate.isEmpty(values)) {
            return (C)this.removeAll(key);
        }
        MutableCollection newValues = (MutableCollection)Iterate.addAllTo(values, (Collection)this.createCollection());
        MutableCollection oldValues = this.map.put(key, newValues);
        oldValues = oldValues == null ? (MutableCollection)this.createCollection() : oldValues;
        this.addToTotalSize(newValues.size() - oldValues.size());
        return (C)oldValues.asUnmodifiable();
    }

    public C removeAll(Object key) {
        MutableCollection collection = (MutableCollection)this.map.remove(key);
        collection = collection == null ? (MutableCollection)this.createCollection() : collection;
        this.subtractFromTotalSize(collection.size());
        return (C)collection.asUnmodifiable();
    }

    @Override
    public void clear() {
        for (MutableCollection collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.clearTotalSize();
    }

    public C get(K key) {
        return (C)((MutableCollection)this.map.getIfAbsentWith(key, this.createCollectionBlock(), this)).asUnmodifiable();
    }

    private C getIfAbsentPutCollection(K key) {
        return (C)((MutableCollection)this.map.getIfAbsentPutWith(key, this.createCollectionBlock(), this));
    }

    @Override
    public MutableMap<K, RichIterable<V>> toMap() {
        final MutableMap<K, C> result = this.map.newEmpty();
        this.map.forEachKeyValue(new Procedure2<K, C>(){

            @Override
            public void value(K key, C collection) {
                MutableCollection mutableCollection = collection.newEmpty();
                mutableCollection.addAll(collection);
                result.put(key, mutableCollection);
            }
        });
        return result;
    }

    @Override
    public <R extends Collection<V>> MutableMap<K, R> toMap(final Function0<R> collectionFactory) {
        final MutableMap<K, C> result = this.createMapWithKeyCount(this.map.size());
        this.map.forEachKeyValue(new Procedure2<K, C>(){

            @Override
            public void value(K key, C collection) {
                Collection mutableCollection = (Collection)collectionFactory.value();
                mutableCollection.addAll(collection);
                result.put(key, mutableCollection);
            }
        });
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.map.size());
        this.map.forEachKeyValue(new MultimapKeyValuesSerializingProcedure(out));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readValuesFrom(in);
    }

    void readValuesFrom(ObjectInput in) throws IOException, ClassNotFoundException {
        int keyCount = in.readInt();
        this.map = this.createMapWithKeyCount(keyCount);
        for (int k = 0; k < keyCount; ++k) {
            Object key = in.readObject();
            int valuesSize = in.readInt();
            MutableCollection values = (MutableCollection)this.createCollection();
            for (int v = 0; v < valuesSize; ++v) {
                values.add(in.readObject());
            }
            this.addToTotalSize(valuesSize);
            this.map.put(key, values);
        }
    }
}

