/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.parallel;

import java.util.concurrent.Executor;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.factory.Iterables;
import org.eclipse.collections.impl.parallel.ArrayProcedureFJTaskRunner;
import org.eclipse.collections.impl.parallel.Combiner;
import org.eclipse.collections.impl.parallel.ParallelIterate;
import org.eclipse.collections.impl.parallel.ProcedureFactory;
import org.eclipse.collections.impl.utility.ArrayIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParallelArrayIterate {
    private ParallelArrayIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T, BT extends Procedure<? super T>> void forEach(T[] array, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner) {
        int taskCount = Math.max(ParallelIterate.DEFAULT_PARALLEL_TASK_COUNT, array.length / 10000);
        ParallelArrayIterate.forEach(array, procedureFactory, combiner, 10000, taskCount);
    }

    public static <T, BT extends Procedure<? super T>> void forEach(T[] array, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int minForkSize, int taskCount) {
        ParallelArrayIterate.forEachOn(array, procedureFactory, combiner, minForkSize, taskCount, ParallelIterate.EXECUTOR_SERVICE);
    }

    public static <T, BT extends Procedure<? super T>> void forEachOn(T[] array, ProcedureFactory<BT> procedureFactory, Combiner<BT> combiner, int minForkSize, int taskCount, Executor executor) {
        if (ArrayIterate.notEmpty(array)) {
            int size = array.length;
            if (size < minForkSize) {
                BT procedure = procedureFactory.create();
                ArrayIterate.forEach(array, procedure);
                ParallelArrayIterate.combineSingleProcedure(combiner, procedure);
            } else {
                int threadCount = Math.min(size, taskCount);
                new ArrayProcedureFJTaskRunner<T, BT>(combiner, threadCount).executeAndCombine(executor, procedureFactory, array);
            }
        }
    }

    private static <T, BT extends Procedure<? super T>> void combineSingleProcedure(Combiner<BT> combiner, BT procedure) {
        if (combiner.useCombineOne()) {
            combiner.combineOne(procedure);
        } else {
            combiner.combineAll(Iterables.iList(procedure));
        }
    }
}

