/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyBooleanIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanSetSerializationProxy;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableFalseSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableTrueSet;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableBooleanEmptySet
implements ImmutableBooleanSet,
Serializable {
    static final ImmutableBooleanSet INSTANCE = new ImmutableBooleanEmptySet();
    private static final boolean[] TO_ARRAY = new boolean[0];

    private ImmutableBooleanEmptySet() {
    }

    @Override
    public ImmutableBooleanSet newWith(boolean element) {
        return element ? ImmutableTrueSet.INSTANCE : ImmutableFalseSet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet newWithout(boolean element) {
        return this;
    }

    @Override
    public ImmutableBooleanSet newWithAll(BooleanIterable elements) {
        ImmutableBooleanSet result = this;
        BooleanIterator booleanIterator = elements.booleanIterator();
        while (booleanIterator.hasNext()) {
            result = result.newWith(booleanIterator.next());
        }
        return result;
    }

    @Override
    public ImmutableBooleanSet newWithoutAll(BooleanIterable elements) {
        return this;
    }

    @Override
    public BooleanIterator booleanIterator() {
        return ImmutableEmptyBooleanIterator.INSTANCE;
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
    }

    @Override
    public void each(BooleanProcedure procedure) {
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return false;
    }

    @Override
    public ImmutableBooleanSet select(BooleanPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableBooleanSet reject(BooleanPredicate predicate) {
        return this;
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return ifNone;
    }

    @Override
    public <V> ImmutableSet<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Sets.immutable.with();
    }

    @Override
    public boolean[] toArray() {
        return TO_ARRAY;
    }

    @Override
    public boolean contains(boolean value) {
        return false;
    }

    @Override
    public boolean containsAll(boolean ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator = source.booleanIterator();
        return !iterator.hasNext();
    }

    @Override
    public BooleanSet freeze() {
        return this;
    }

    @Override
    public ImmutableBooleanSet toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanSet)) {
            return false;
        }
        BooleanSet other = (BooleanSet)obj;
        return other.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanArrayList.newList(this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet(this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag(this);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    private Object writeReplace() {
        return new ImmutableBooleanSetSerializationProxy(this);
    }
}

