/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedFloatProcedure;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

public final class ImmutableFloatSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private FloatSet set;

    public ImmutableFloatSetSerializationProxy() {
    }

    public ImmutableFloatSetSerializationProxy(FloatSet set) {
        this.set = set;
    }

    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedFloatProcedure(){

                public void safeValue(float item) throws Exception {
                    out.writeFloat(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        FloatHashSet deserializedSet = new FloatHashSet(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readFloat());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

