/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.LongStack;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableLongEmptyStack
implements ImmutableLongStack,
Serializable {
    static final ImmutableLongStack INSTANCE = new ImmutableLongEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableLongEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public LongIterator longIterator() {
        return ImmutableEmptyLongIterator.INSTANCE;
    }

    @Override
    public void forEach(LongProcedure procedure) {
    }

    @Override
    public void each(LongProcedure procedure) {
    }

    @Override
    public int count(LongPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return true;
    }

    @Override
    public long peek() {
        throw new EmptyStackException();
    }

    @Override
    public LongList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new LongArrayList(0);
        }
        throw new EmptyStackException();
    }

    @Override
    public long peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    @Override
    public ImmutableLongStack select(LongPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableLongStack reject(LongPredicate predicate) {
        return this;
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public long max() {
        throw new NoSuchElementException();
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return defaultValue;
    }

    @Override
    public long min() {
        throw new NoSuchElementException();
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public long[] toSortedArray() {
        return new long[0];
    }

    @Override
    public MutableLongList toSortedList() {
        return new LongArrayList();
    }

    @Override
    public long[] toArray() {
        return new long[0];
    }

    @Override
    public boolean contains(long value) {
        return false;
    }

    @Override
    public boolean containsAll(long ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableLongList toList() {
        return new LongArrayList();
    }

    @Override
    public MutableLongSet toSet() {
        return new LongHashSet();
    }

    @Override
    public MutableLongBag toBag() {
        return new LongHashBag();
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public ImmutableLongStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableLongStack push(long element) {
        return LongStacks.immutable.with(element);
    }

    @Override
    public ImmutableLongStack pop() {
        throw new EmptyStackException();
    }

    @Override
    public ImmutableLongStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof LongStack)) {
            return false;
        }
        LongStack stack = (LongStack)otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

