/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal;

import java.util.Iterator;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutableCollectionIterate {
    private MutableCollectionIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> RichIterable<RichIterable<T>> chunk(MutableCollection<T> collection, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        Iterator iterator = collection.iterator();
        MutableList<RichIterable<T>> result = Lists.mutable.empty();
        while (iterator.hasNext()) {
            MutableCollection<T> batch = collection.newEmpty();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add(batch);
        }
        return result;
    }
}

