/*
 * Decompiled with CFR 0.152.
 */
package org.jvirtanen.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Configs {
    private Configs() {
    }

    public static InetAddress getInetAddress(Config config, String path) {
        try {
            return InetAddress.getByName(config.getString(path));
        }
        catch (UnknownHostException e) {
            throw Configs.badValue(e, config, path);
        }
    }

    public static NetworkInterface getNetworkInterface(Config config, String path) {
        NetworkInterface value = Configs.getNetworkInterfaceByName(config, path);
        if (value == null) {
            value = Configs.getNetworkInterfaceByInetAddress(config, path);
        }
        if (value == null) {
            throw Configs.badValue("No network interface for value '" + config.getString(path) + "'", config, path);
        }
        return value;
    }

    public static int getPort(Config config, String path) {
        try {
            return new InetSocketAddress(config.getInt(path)).getPort();
        }
        catch (IllegalArgumentException e) {
            throw Configs.badValue(e, config, path);
        }
    }

    private static NetworkInterface getNetworkInterfaceByInetAddress(Config config, String path) {
        try {
            return NetworkInterface.getByInetAddress(Configs.getInetAddress(config, path));
        }
        catch (SocketException e) {
            throw Configs.badValue(e, config, path);
        }
    }

    private static NetworkInterface getNetworkInterfaceByName(Config config, String path) {
        try {
            return NetworkInterface.getByName(config.getString(path));
        }
        catch (SocketException e) {
            throw Configs.badValue(e, config, path);
        }
    }

    private static ConfigException badValue(String message, Config config, String path) {
        return new ConfigException.BadValue(config.getValue(path).origin(), path, message);
    }

    private static ConfigException badValue(Exception cause, Config config, String path) {
        return new ConfigException.BadValue(config.getValue(path).origin(), path, cause.getMessage(), cause);
    }
}

