/*
 * Decompiled with CFR 0.152.
 */
package org.jvirtanen.nio;

import java.nio.ByteBuffer;

public class ByteBuffers {
    private ByteBuffers() {
    }

    public static short getUnsigned(ByteBuffer buffer) {
        return (short)(buffer.get() & 0xFF);
    }

    public static short getUnsigned(ByteBuffer buffer, int index) {
        return (short)(buffer.get(index) & 0xFF);
    }

    public static void putUnsigned(ByteBuffer buffer, short b) {
        buffer.put((byte)b);
    }

    public static void putUnsigned(ByteBuffer buffer, int index, short b) {
        buffer.put(index, (byte)b);
    }

    public static int getUnsignedShort(ByteBuffer buffer) {
        return buffer.getShort() & 0xFFFF;
    }

    public static int getUnsignedShort(ByteBuffer buffer, int index) {
        return buffer.getShort(index) & 0xFFFF;
    }

    public static void putUnsignedShort(ByteBuffer buffer, int value) {
        buffer.putShort((short)value);
    }

    public static void putUnsignedShort(ByteBuffer buffer, int index, int value) {
        buffer.putShort(index, (short)value);
    }

    public static long getUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public static long getUnsignedInt(ByteBuffer buffer, int index) {
        return (long)buffer.getInt(index) & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer buffer, long value) {
        buffer.putInt((int)value);
    }

    public static void putUnsignedInt(ByteBuffer buffer, int index, long value) {
        buffer.putInt(index, (int)value);
    }
}

