/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.match;

import com.paritytrading.parity.match.Order;
import com.paritytrading.parity.match.OrderBookListener;
import com.paritytrading.parity.match.PriceLevel;
import com.paritytrading.parity.match.Side;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.LongComparators;
import java.util.Comparator;

public class OrderBook {
    private Long2ObjectRBTreeMap<PriceLevel> bids = new Long2ObjectRBTreeMap((Comparator)LongComparators.OPPOSITE_COMPARATOR);
    private Long2ObjectRBTreeMap<PriceLevel> asks = new Long2ObjectRBTreeMap((Comparator)LongComparators.NATURAL_COMPARATOR);
    private Long2ObjectOpenHashMap<Order> orders = new Long2ObjectOpenHashMap();
    private OrderBookListener listener;

    public OrderBook(OrderBookListener listener) {
        this.listener = listener;
    }

    public void enter(long orderId, Side side, long price, long size) {
        if (this.orders.containsKey(orderId)) {
            return;
        }
        if (side == Side.BUY) {
            this.buy(orderId, price, size);
        } else {
            this.sell(orderId, price, size);
        }
    }

    private void buy(long orderId, long price, long size) {
        long remainingQuantity = size;
        PriceLevel bestLevel = this.getBestLevel(this.asks);
        while (remainingQuantity > 0L && bestLevel != null && bestLevel.getPrice() <= price) {
            remainingQuantity = bestLevel.match(orderId, Side.BUY, remainingQuantity, this.listener);
            if (bestLevel.isEmpty()) {
                this.asks.remove(bestLevel.getPrice());
            }
            bestLevel = this.getBestLevel(this.asks);
        }
        if (remainingQuantity > 0L) {
            this.orders.put(orderId, (Object)this.add(this.bids, orderId, Side.BUY, price, remainingQuantity));
            this.listener.add(orderId, Side.BUY, price, remainingQuantity);
        }
    }

    private void sell(long orderId, long price, long size) {
        long remainingQuantity = size;
        PriceLevel bestLevel = this.getBestLevel(this.bids);
        while (remainingQuantity > 0L && bestLevel != null && bestLevel.getPrice() >= price) {
            remainingQuantity = bestLevel.match(orderId, Side.SELL, remainingQuantity, this.listener);
            if (bestLevel.isEmpty()) {
                this.bids.remove(bestLevel.getPrice());
            }
            bestLevel = this.getBestLevel(this.bids);
        }
        if (remainingQuantity > 0L) {
            this.orders.put(orderId, (Object)this.add(this.asks, orderId, Side.SELL, price, remainingQuantity));
            this.listener.add(orderId, Side.SELL, price, remainingQuantity);
        }
    }

    public void cancel(long orderId, long size) {
        Order order = (Order)this.orders.get(orderId);
        if (order == null) {
            return;
        }
        long remainingQuantity = order.getRemainingQuantity();
        if (size >= remainingQuantity) {
            return;
        }
        if (size > 0L) {
            order.resize(size);
        } else {
            this.delete(order);
            this.orders.remove(orderId);
        }
        this.listener.cancel(orderId, remainingQuantity - size, size);
    }

    private PriceLevel getBestLevel(Long2ObjectRBTreeMap<PriceLevel> levels) {
        if (levels.isEmpty()) {
            return null;
        }
        return (PriceLevel)levels.get(levels.firstLongKey());
    }

    private Order add(Long2ObjectRBTreeMap<PriceLevel> levels, long orderId, Side side, long price, long size) {
        PriceLevel level = (PriceLevel)levels.get(price);
        if (level == null) {
            level = new PriceLevel(side, price);
            levels.put(price, (Object)level);
        }
        return level.add(orderId, size);
    }

    private void delete(Order order) {
        PriceLevel level = order.getLevel();
        level.delete(order);
        if (level.isEmpty()) {
            this.delete(level);
        }
    }

    private void delete(PriceLevel level) {
        switch (level.getSide()) {
            case BUY: {
                this.bids.remove(level.getPrice());
                break;
            }
            case SELL: {
                this.asks.remove(level.getPrice());
            }
        }
    }
}

