/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.parity.match;

import com.paritytrading.parity.match.Order;
import com.paritytrading.parity.match.OrderBookListener;
import com.paritytrading.parity.match.Side;
import java.util.ArrayList;

class PriceLevel {
    private Side side;
    private long price;
    private ArrayList<Order> orders;

    public PriceLevel(Side side, long price) {
        this.side = side;
        this.price = price;
        this.orders = new ArrayList();
    }

    public Side getSide() {
        return this.side;
    }

    public long getPrice() {
        return this.price;
    }

    public boolean isEmpty() {
        return this.orders.isEmpty();
    }

    public Order add(long orderId, long size) {
        Order order = new Order(this, orderId, size);
        this.orders.add(order);
        return order;
    }

    public long match(long orderId, Side side, long quantity, OrderBookListener listener) {
        while (quantity > 0L && !this.orders.isEmpty()) {
            Order order = this.orders.get(0);
            long orderQuantity = order.getRemainingQuantity();
            if (orderQuantity > quantity) {
                order.reduce(quantity);
                listener.match(order.getId(), orderId, side, this.price, quantity, order.getRemainingQuantity());
                quantity = 0L;
                continue;
            }
            this.orders.remove(0);
            listener.match(order.getId(), orderId, side, this.price, orderQuantity, 0L);
            quantity -= orderQuantity;
        }
        return quantity;
    }

    public void delete(Order order) {
        this.orders.remove(order);
    }
}

