/*
 * Decompiled with CFR 0.152.
 */
package com.granveaud.mysql2h2converter;

import com.granveaud.mysql2h2converter.parser.ParseException;
import com.granveaud.mysql2h2converter.parser.ReaderProvider;
import com.granveaud.mysql2h2converter.parser.SQLParser;
import com.granveaud.mysql2h2converter.sql.SqlStatement;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;

public class SQLParserManager {
    public static SqlStatement parseStatement(String str) throws ParseException {
        return SQLParserManager.parseStatement(new StringReader(str));
    }

    public static SqlStatement parseStatement(Reader reader) throws ParseException {
        SQLParser parser = new SQLParser(new ReaderProvider(reader));
        return parser.Statement();
    }

    public static Iterator<SqlStatement> parseScript(Reader reader) throws ParseException {
        SQLParser parser = new SQLParser(new ReaderProvider(reader));
        return new ScriptIterator(parser);
    }

    static class ScriptIterator
    implements Iterator<SqlStatement> {
        private SQLParser parser;
        private SqlStatement nextStatement;

        ScriptIterator(SQLParser parser) {
            this.parser = parser;
            this.parseNextStatement();
        }

        private void parseNextStatement() {
            try {
                this.nextStatement = this.parser.ScriptStatement();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Cannot parse next statement", e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextStatement != null;
        }

        @Override
        public SqlStatement next() {
            SqlStatement result = this.nextStatement;
            this.parseNextStatement();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

