/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.tunnel;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.pastdev.jsch.IOUtils;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.tunnel.Tunnel;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelConnection
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(TunnelConnection.class);
    private Map<String, Tunnel> tunnelsByDestination;
    private Session session;
    private SessionFactory sessionFactory;
    private Iterable<Tunnel> tunnels;

    public TunnelConnection(SessionFactory sessionFactory, int localPort, String destinationHostname, int destinationPort) {
        this(sessionFactory, new Tunnel(localPort, destinationHostname, destinationPort));
    }

    public TunnelConnection(SessionFactory sessionFactory, Tunnel ... tunnels) {
        this(sessionFactory, Arrays.asList(tunnels));
    }

    public TunnelConnection(SessionFactory sessionFactory, List<Tunnel> tunnels) {
        this.sessionFactory = sessionFactory;
        this.tunnels = tunnels;
        this.tunnelsByDestination = new HashMap<String, Tunnel>();
        for (Tunnel tunnel : tunnels) {
            this.tunnelsByDestination.put(this.hostnamePortKey(tunnel), tunnel);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        this.session = null;
        for (Tunnel tunnel : this.tunnels) {
            tunnel.setAssignedLocalPort(0);
        }
    }

    public Tunnel getTunnel(String destinationHostname, int destinationPort) {
        return this.tunnelsByDestination.get(this.hostnamePortKey(destinationHostname, destinationPort));
    }

    private String hostnamePortKey(Tunnel tunnel) {
        return this.hostnamePortKey(tunnel.getDestinationHostname(), tunnel.getDestinationPort());
    }

    private String hostnamePortKey(String hostname, int port) {
        return hostname + ":" + port;
    }

    public boolean isOpen() {
        return this.session != null && this.session.isConnected();
    }

    public void open() throws JSchException {
        if (this.isOpen()) {
            return;
        }
        this.session = this.sessionFactory.newSession();
        logger.debug("connecting session");
        this.session.connect();
        for (Tunnel tunnel : this.tunnels) {
            int assignedPort = 0;
            assignedPort = tunnel.getLocalAlias() == null ? this.session.setPortForwardingL(tunnel.getLocalPort(), tunnel.getDestinationHostname(), tunnel.getDestinationPort()) : this.session.setPortForwardingL(tunnel.getLocalAlias(), tunnel.getLocalPort(), tunnel.getDestinationHostname(), tunnel.getDestinationPort());
            tunnel.setAssignedLocalPort(assignedPort);
            logger.debug("added tunnel {}", (Object)tunnel);
        }
        logger.info("forwarding {}", (Object)this);
    }

    public void reopen() throws JSchException {
        IOUtils.closeAndLogException(this);
        this.open();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.sessionFactory.toString());
        for (Tunnel tunnel : this.tunnels) {
            builder.append(" -L ").append(tunnel);
        }
        return builder.toString();
    }
}

