/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.nio.file.AbstractSshFileSystem;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;

public abstract class AbstractSshPath
implements Path {
    public static final String QUOTED_SPECIAL = "\"$";
    private AbstractSshFileSystem fileSystem;

    public static String protect(String string, String special) {
        if (string.equals("")) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (special.indexOf(c) != -1) {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected AbstractSshPath(AbstractSshFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public AbstractSshFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getHostname() {
        return this.getFileSystem().getUri().getHost();
    }

    @Override
    public Path getFileName() {
        return this.getName(this.getNameCount() - 1);
    }

    public int getPort() {
        return this.getFileSystem().getUri().getPort();
    }

    public String getUsername() {
        return this.getFileSystem().getUri().getUserInfo();
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            int index = 0;
            int count = AbstractSshPath.this.getNameCount();

            @Override
            public boolean hasNext() {
                return this.index < this.count;
            }

            @Override
            public Path next() {
                return AbstractSshPath.this.getName(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("path not from default provider");
    }

    public String quotedString() {
        return '\"' + AbstractSshPath.protect(this.toString(), QUOTED_SPECIAL) + '\"';
    }
}

