/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.nio.file.UnixSshFileSystemWatchService;
import com.pastdev.jsch.nio.file.UnixSshPath;
import com.pastdev.jsch.nio.file.UnixSshPathWatchEvent;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixSshPathWatchKey
implements WatchKey,
Runnable {
    private static Logger logger = LoggerFactory.getLogger(UnixSshPathWatchKey.class);
    private Map<UnixSshPath, UnixSshPathWatchEvent<Path>> addMap;
    private boolean cancelled;
    private Map<UnixSshPath, UnixSshPathWatchEvent<Path>> deleteMap;
    UnixSshPath dir;
    Map<UnixSshPath, PosixFileAttributes> entries;
    private boolean initialized;
    private Set<WatchEvent.Kind<?>> kindsToWatch;
    private Map<UnixSshPath, UnixSshPathWatchEvent<Path>> modifyMap;
    private long pollingInterval;
    private TimeUnit pollingIntervalTimeUnit;
    private State state;
    private UnixSshFileSystemWatchService watchService;
    private ReentrantLock mapLock = new ReentrantLock();
    private ReentrantLock stateLock = new ReentrantLock();
    ReentrantLock pollerLock = new ReentrantLock();
    private Condition initializationComplete = this.pollerLock.newCondition();
    private Condition runImmediately = this.pollerLock.newCondition();

    public UnixSshPathWatchKey(UnixSshFileSystemWatchService watchService, UnixSshPath dir, WatchEvent.Kind<?>[] kinds, long pollingInterval, TimeUnit pollingIntervalTimeUnit) {
        this.watchService = watchService;
        this.dir = dir;
        this.kindsToWatch = new HashSet();
        this.kindsToWatch.addAll(Arrays.asList(kinds));
        this.pollingInterval = pollingInterval;
        this.pollingIntervalTimeUnit = pollingIntervalTimeUnit;
        this.cancelled = false;
        this.initialized = false;
        this.addMap = new HashMap<UnixSshPath, UnixSshPathWatchEvent<Path>>();
        this.deleteMap = new HashMap<UnixSshPath, UnixSshPathWatchEvent<Path>>();
        this.modifyMap = new HashMap<UnixSshPath, UnixSshPathWatchEvent<Path>>();
        this.state = State.READY;
    }

    void addCreateEvent(UnixSshPath path) {
        if (this.kindsToWatch.contains(StandardWatchEventKinds.ENTRY_CREATE)) {
            try {
                this.mapLock.lock();
                logger.trace("added: {}", (Object)path);
                if (!this.addMap.containsKey(path)) {
                    this.addMap.put(path, new UnixSshPathWatchEvent<UnixSshPath>(StandardWatchEventKinds.ENTRY_CREATE, path));
                }
            }
            finally {
                this.mapLock.unlock();
            }
            this.signal();
        }
    }

    void addDeleteEvent(UnixSshPath path) {
        if (this.kindsToWatch.contains(StandardWatchEventKinds.ENTRY_DELETE)) {
            try {
                this.mapLock.lock();
                logger.trace("deleted: {}", (Object)path);
                if (!this.deleteMap.containsKey(path)) {
                    this.deleteMap.put(path, new UnixSshPathWatchEvent<UnixSshPath>(StandardWatchEventKinds.ENTRY_DELETE, path));
                }
            }
            finally {
                this.mapLock.unlock();
            }
            this.signal();
        }
    }

    void addModifyEvent(UnixSshPath path) {
        if (this.kindsToWatch.contains(StandardWatchEventKinds.ENTRY_MODIFY)) {
            try {
                this.mapLock.lock();
                logger.trace("modified: {}", (Object)path);
                if (this.modifyMap.containsKey(path)) {
                    this.modifyMap.get(path).increment();
                } else {
                    UnixSshPathWatchEvent<UnixSshPath> event = new UnixSshPathWatchEvent<UnixSshPath>(StandardWatchEventKinds.ENTRY_MODIFY, path);
                    this.modifyMap.put(path, event);
                }
            }
            finally {
                this.mapLock.unlock();
            }
            this.signal();
        }
    }

    @Override
    public void cancel() {
        this.watchService.unregister(this);
        this.cancelled = true;
    }

    @Override
    public boolean isValid() {
        return !this.cancelled && !this.watchService.closed();
    }

    private static boolean modified(PosixFileAttributes attributes, PosixFileAttributes otherAttributes) {
        if (attributes.size() != otherAttributes.size()) {
            return true;
        }
        return attributes.lastModifiedTime() != otherAttributes.lastModifiedTime();
    }

    @Override
    public List<WatchEvent<?>> pollEvents() {
        try {
            this.mapLock.lock();
            ArrayList<UnixSshPathWatchEvent<Path>> currentEvents = new ArrayList<UnixSshPathWatchEvent<Path>>();
            currentEvents.addAll(this.addMap.values());
            currentEvents.addAll(this.deleteMap.values());
            currentEvents.addAll(this.modifyMap.values());
            this.addMap.clear();
            this.deleteMap.clear();
            this.modifyMap.clear();
            List<WatchEvent<?>> list = Collections.unmodifiableList(currentEvents);
            return list;
        }
        finally {
            this.mapLock.unlock();
        }
    }

    @Override
    public boolean reset() {
        if (!this.isValid()) {
            return false;
        }
        try {
            this.mapLock.lock();
            if (this.addMap.size() > 0 || this.deleteMap.size() > 0 || this.modifyMap.size() > 0) {
                this.signal();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.mapLock.unlock();
        }
        try {
            this.stateLock.lock();
            this.state = State.READY;
        }
        finally {
            this.stateLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean first = true;
        try {
            while (this.isValid()) {
                block16: {
                    try {
                        logger.trace("polling {}", (Object)this.dir);
                        Map<UnixSshPath, PosixFileAttributes> entries = this.dir.getFileSystem().provider().statDirectory(this.dir);
                        logger.trace("got response {}", (Object)this.dir);
                        if (first) {
                            first = false;
                            this.entries = entries;
                            try {
                                this.pollerLock.lock();
                                logger.trace("initialization complete got lock");
                                this.initialized = true;
                                this.initializationComplete.signalAll();
                                logger.debug("poller is initialized");
                                break block16;
                            }
                            finally {
                                this.pollerLock.unlock();
                            }
                        }
                        for (UnixSshPath entryPath : entries.keySet()) {
                            if (this.entries.containsKey(entryPath)) {
                                if (!UnixSshPathWatchKey.modified(entries.get(entryPath), this.entries.remove(entryPath))) continue;
                                this.addModifyEvent(entryPath);
                                continue;
                            }
                            this.addCreateEvent(entryPath);
                        }
                        for (UnixSshPath entryPath : this.entries.keySet()) {
                            this.addDeleteEvent(entryPath);
                        }
                        this.entries = entries;
                    }
                    catch (IOException e) {
                        logger.error("checking {} failed: {}", (Object)this.dir, (Object)e);
                        logger.debug("checking directory failed: ", (Throwable)e);
                    }
                }
                try {
                    this.pollerLock.lock();
                    logger.trace("poller entering await {} {}", (Object)this.pollingInterval, (Object)this.pollingIntervalTimeUnit);
                    this.runImmediately.await(this.pollingInterval, this.pollingIntervalTimeUnit);
                }
                finally {
                    this.pollerLock.unlock();
                }
            }
        }
        catch (ClosedWatchServiceException e) {
            logger.debug("watch service was closed, so exit");
        }
        catch (InterruptedException e) {
            logger.debug("interrupt caught, closing down poller");
        }
        logger.info("poller stopped for {}", (Object)this.dir);
    }

    void runImmediately() {
        try {
            this.pollerLock.lock();
            this.runImmediately.signal();
        }
        finally {
            this.pollerLock.unlock();
        }
    }

    private void signal() {
        try {
            this.stateLock.lock();
            logger.trace("signaling");
            if (this.state != State.SIGNALLED) {
                this.state = State.SIGNALLED;
                logger.trace("enqueueing {}", (Object)this);
                this.watchService.enqueue(this);
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForInitialization(long time, TimeUnit timeUnit) {
        logger.debug("waiting {} {} for initialization", (Object)time, (Object)timeUnit);
        try {
            this.pollerLock.lock();
            logger.debug("wait for initialization obtained lock");
            if (this.initialized) {
                boolean bl = true;
                return bl;
            }
            this.initializationComplete.await(time, timeUnit);
            logger.debug("initialization complete");
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.pollerLock.unlock();
        }
    }

    @Override
    public UnixSshPath watchable() {
        return this.dir;
    }

    private static enum State {
        READY,
        SIGNALLED;

    }
}

