/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.nio.file.UnixSshFileSystemProvider;
import com.pastdev.jsch.nio.file.UnixSshPath;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Set;

public class UnixSshSeekableByteChannel
implements SeekableByteChannel {
    private boolean append;
    private boolean open;
    private UnixSshPath path;
    private long position = 0L;
    private UnixSshFileSystemProvider provider;
    private boolean readable;
    private long size;
    private boolean writeable;

    public UnixSshSeekableByteChannel(UnixSshPath path, Set<? extends OpenOption> openOptions, FileAttribute<?> ... createFileAttributes) throws IOException {
        this.path = path.toAbsolutePath();
        this.append = openOptions.contains(StandardOpenOption.APPEND);
        this.readable = openOptions.isEmpty() || openOptions.contains(StandardOpenOption.READ);
        this.writeable = openOptions.contains(StandardOpenOption.WRITE);
        this.provider = path.getFileSystem().provider();
        PosixFileAttributes attributes = null;
        try {
            this.provider.checkAccess(path, new AccessMode[0]);
            attributes = this.provider.readAttributes((Path)path, PosixFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        boolean create = false;
        if (openOptions.contains(StandardOpenOption.CREATE_NEW)) {
            if (attributes != null) {
                throw new FileAlreadyExistsException(path.toString());
            }
            create = true;
        } else if (openOptions.contains(StandardOpenOption.CREATE)) {
            if (attributes == null) {
                create = true;
            }
        } else if (attributes == null) {
            throw new NoSuchFileException("file not found and no CREATE/CREATE_NEW specified for " + path.toString());
        }
        if (create) {
            attributes = this.provider.createFile(path, createFileAttributes);
        }
        this.size = attributes.size();
        this.open = true;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public UnixSshSeekableByteChannel position(long position) throws IOException {
        this.position = position;
        return this;
    }

    @Override
    public int read(ByteBuffer bytes) throws IOException {
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (this.position >= this.size) {
            return -1;
        }
        int read = this.provider.read(this.path, this.position, bytes);
        this.position += (long)read;
        if (this.position > this.size) {
            this.size = this.position;
        }
        return read;
    }

    @Override
    public long size() throws IOException {
        return this.size;
    }

    @Override
    public UnixSshSeekableByteChannel truncate(long size) throws IOException {
        if (!this.writeable) {
            throw new NonWritableChannelException();
        }
        if (size < 0L) {
            throw new IllegalArgumentException("size must be positive");
        }
        if (size >= this.size) {
            return this;
        }
        this.provider.truncateFile(this.path, this.position);
        if (this.position > size) {
            this.position = size;
        }
        this.size = size;
        return this;
    }

    @Override
    public int write(ByteBuffer bytes) throws IOException {
        if (!this.writeable) {
            throw new NonWritableChannelException();
        }
        if (this.append) {
            this.position = this.size();
        }
        int written = this.provider.write(this.path, this.position, bytes);
        this.position += (long)written;
        if (this.position > this.size) {
            this.size = this.position;
        }
        return written;
    }
}

