/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.pastdev.jsch.nio.file.UnixSshFileSystem;
import com.pastdev.jsch.nio.file.UnixSshFileSystemProvider;
import com.pastdev.jsch.nio.file.UnixSshPath;
import com.pastdev.jsch.nio.file.UnixSshSftpHybridFileSystem;
import com.pastdev.jsch.sftp.SftpRunner;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixSshSftpHybridFileSystemProvider
extends UnixSshFileSystemProvider {
    private static final Logger logger = LoggerFactory.getLogger(UnixSshSftpHybridFileSystemProvider.class);
    public static final String SCHEME_SSH_SFTP_HYBRID_UNIX = "sshSftpHybrid.unix";
    private Map<URI, UnixSshSftpHybridFileSystem> fileSystemMap = new HashMap<URI, UnixSshSftpHybridFileSystem>();

    @Override
    UnixSshPath checkPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof UnixSshPath)) {
            throw new IllegalArgumentException("path not an instanceof UnixSshSftpHybridPath");
        }
        return (UnixSshPath)path;
    }

    @Override
    public void createDirectory(Path path, FileAttribute<?> ... fileAttributes) throws IOException {
        final UnixSshPath unixPath = this.checkPath(path);
        Set permissions = null;
        for (FileAttribute<?> fileAttribute : fileAttributes) {
            if (!fileAttribute.name().equals("posix:permissions")) continue;
            permissions = (Set)fileAttribute.value();
        }
        final int permissionsAsInt = permissions == null ? -1 : UnixSshSftpHybridFileSystemProvider.toInt(permissions);
        try {
            logger.debug("Getting sftpRunner to execute sftp createDirectory");
            ((UnixSshSftpHybridFileSystem)unixPath.getFileSystem()).getSftpRunner().execute(new SftpRunner.Sftp(){

                public void run(ChannelSftp sftp) throws IOException {
                    String abspath = unixPath.toAbsolutePath().toString();
                    SftpATTRS stat = null;
                    try {
                        stat = sftp.lstat(abspath);
                    }
                    catch (SftpException sftpException) {
                        // empty catch block
                    }
                    if (stat != null && stat.isDir()) {
                        throw new FileAlreadyExistsException("Directory " + unixPath + " already exists");
                    }
                    if (stat == null || !stat.isDir()) {
                        try {
                            sftp.mkdir(abspath);
                        }
                        catch (SftpException e) {
                            throw new IOException("Could not create directory", e);
                        }
                    }
                    if (permissionsAsInt >= 0) {
                        try {
                            sftp.chmod(permissionsAsInt, abspath);
                        }
                        catch (SftpException e) {
                            throw new IOException("Could change permission on created directory", e);
                        }
                    }
                }
            });
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        UnixSshFileSystem fileSystem = this.fileSystemMap.get(uri.resolve("/"));
        if (fileSystem == null) {
            throw new FileSystemNotFoundException("no filesystem defined for " + uri.toString());
        }
        return fileSystem;
    }

    @Override
    public String getScheme() {
        return SCHEME_SSH_SFTP_HYBRID_UNIX;
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> environment) throws IOException {
        URI baseUri = uri.resolve("/");
        UnixSshSftpHybridFileSystem existing = this.fileSystemMap.get(baseUri);
        if (existing != null) {
            throw new RuntimeException("filesystem already exists for " + uri.toString() + " at " + existing.toString());
        }
        UnixSshSftpHybridFileSystem fileSystem = new UnixSshSftpHybridFileSystem(this, uri, environment);
        this.fileSystemMap.put(baseUri, fileSystem);
        return fileSystem;
    }

    @Override
    void removeFileSystem(UnixSshFileSystem fileSystem) {
        this.fileSystemMap.remove(fileSystem.getUri().resolve("/"));
    }

    private static int toInt(Set<PosixFilePermission> permissions) {
        int value = 0;
        for (PosixFilePermission permission : permissions) {
            switch (permission) {
                case OWNER_READ: {
                    value |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    value |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    value |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    value |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    value |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    value |= 8;
                    break;
                }
                case OTHERS_READ: {
                    value |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    value |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    value |= 1;
                }
            }
        }
        return value;
    }
}

