/*
 * Decompiled with CFR 0.152.
 */
package com.paulgoldbaum.influxdbclient;

import com.paulgoldbaum.influxdbclient.DatabaseManagement;
import com.paulgoldbaum.influxdbclient.DatabaseManagement$class;
import com.paulgoldbaum.influxdbclient.DatabaseNotFoundException;
import com.paulgoldbaum.influxdbclient.HttpClient;
import com.paulgoldbaum.influxdbclient.HttpException;
import com.paulgoldbaum.influxdbclient.InfluxDB;
import com.paulgoldbaum.influxdbclient.MalformedRequestException;
import com.paulgoldbaum.influxdbclient.Parameter;
import com.paulgoldbaum.influxdbclient.Point;
import com.paulgoldbaum.influxdbclient.QueryResult;
import com.paulgoldbaum.influxdbclient.RequestNotCompletedException;
import com.paulgoldbaum.influxdbclient.RetentionPolicyManagement;
import com.paulgoldbaum.influxdbclient.RetentionPolicyManagement$class;
import com.paulgoldbaum.influxdbclient.ServerUnavailableException;
import com.paulgoldbaum.influxdbclient.UnknownErrorException;
import com.paulgoldbaum.influxdbclient.WriteException;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001%\u0011\u0001\u0002R1uC\n\f7/\u001a\u0006\u0003\u0007\u0011\ta\"\u001b8gYVDHMY2mS\u0016tGO\u0003\u0002\u0006\r\u0005a\u0001/Y;mO>dGMY1v[*\tq!A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u00159\t\u0002CA\u0006\r\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005!IeN\u001a7vq\u0012\u0013\u0005CA\u0006\u0010\u0013\t\u0001\"AA\rSKR,g\u000e^5p]B{G.[2z\u001b\u0006t\u0017mZ3nK:$\bCA\u0006\u0013\u0013\t\u0019\"A\u0001\nECR\f'-Y:f\u001b\u0006t\u0017mZ3nK:$\b\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0019\u0011\fG/\u00192bg\u0016t\u0015-\\3\u0016\u0003]\u0001\"\u0001\u0007\u0010\u000f\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0002\rA\u0013X\rZ3g\u0013\ty\u0002E\u0001\u0004TiJLgn\u001a\u0006\u0003;iA\u0001B\t\u0001\u0003\u0002\u0003\u0006IaF\u0001\u000eI\u0006$\u0018MY1tK:\u000bW.\u001a\u0011\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\n!\u0002\u001b;ua\u000ec\u0017.\u001a8u!\tYa%\u0003\u0002(\u0005\tQ\u0001\n\u001e;q\u00072LWM\u001c;\t\r%\u0002A\u0011\u0003\u0002+\u0003\u0019a\u0014N\\5u}Q\u00191\u0006L\u0017\u0011\u0005-\u0001\u0001\"B\u000b)\u0001\u00049\u0002\"\u0002\u0013)\u0001\u0004)\u0003\"B\u0018\u0001\t\u0003\u0001\u0014!B<sSR,G#B\u0019;\u007fUs\u0006c\u0001\u001a6o5\t1G\u0003\u000255\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Y\u001a$A\u0002$viV\u0014X\r\u0005\u0002\u001aq%\u0011\u0011H\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015Yd\u00061\u0001=\u0003\u0015\u0001x.\u001b8u!\tYQ(\u0003\u0002?\u0005\t)\u0001k\\5oi\"9\u0001I\fI\u0001\u0002\u0004\t\u0015!\u00039sK\u000eL7/[8o!\t\u0011%K\u0004\u0002D\u001f:\u0011A)\u0014\b\u0003\u000b2s!AR&\u000f\u0005\u001dSU\"\u0001%\u000b\u0005%C\u0011A\u0002\u001fs_>$h(C\u0001\b\u0013\t)a!\u0003\u0002\u0004\t%\u0011aJA\u0001\n!\u0006\u0014\u0018-\\3uKJL!\u0001U)\u0002\u0013A\u0013XmY5tS>t'B\u0001(\u0003\u0013\t\u0019FKA\u0005Qe\u0016\u001c\u0017n]5p]*\u0011\u0001+\u0015\u0005\b-:\u0002\n\u00111\u0001X\u0003-\u0019wN\\:jgR,gnY=\u0011\u0005a[fBA\"Z\u0013\tQ\u0016+A\u0006D_:\u001c\u0018n\u001d;f]\u000eL\u0018B\u0001/^\u0005-\u0019uN\\:jgR,gnY=\u000b\u0005i\u000b\u0006bB0/!\u0003\u0005\raF\u0001\u0010e\u0016$XM\u001c;j_:\u0004v\u000e\\5ds\")\u0011\r\u0001C\u0001E\u0006I!-\u001e7l/JLG/\u001a\u000b\u0006c\rtw\u000e\u001d\u0005\u0006I\u0002\u0004\r!Z\u0001\u0007a>Lg\u000e^:\u0011\u0007\u0019\\GH\u0004\u0002hS:\u0011q\t[\u0005\u00027%\u0011!NG\u0001\ba\u0006\u001c7.Y4f\u0013\taWN\u0001\u0003MSN$(B\u00016\u001b\u0011\u001d\u0001\u0005\r%AA\u0002\u0005CqA\u00161\u0011\u0002\u0003\u0007q\u000bC\u0004`AB\u0005\t\u0019A\f\t\u000bI\u0004A\u0011B:\u0002\u0019\u0015DXmY;uK^\u0013\u0018\u000e^3\u0015\u000bE\"ho\u001e=\t\u000bU\f\b\u0019A\f\u0002\u000fA\f\u0017\u0010\\8bI\")\u0001)\u001da\u0001\u0003\")a+\u001da\u0001/\")q,\u001da\u0001/!)!\u0010\u0001C\u0005w\u0006!\"-^5mI^\u0013\u0018\u000e^3QCJ\fW.\u001a;feN$\u0002\u0002`@\u0002\u0002\u0005\r\u0011Q\u0001\t\u00051u<r#\u0003\u0002\u007fA\t\u0019Q*\u00199\t\u000bUI\b\u0019A\f\t\u000f\u0001K\b\u0013!a\u0001\u0003\"9a+\u001fI\u0001\u0002\u00049\u0006bB0z!\u0003\u0005\ra\u0006\u0005\b\u0003\u0013\u0001A\u0011KA\u0006\u0003Q\u0011W/\u001b7e#V,'/\u001f)be\u0006lW\r^3sgR1\u0011QBA\u0015\u0003[\u0001r!a\u0004\u0002\u001a\u0005mq#\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003%IW.\\;uC\ndWMC\u0002\u0002\u0018i\t!bY8mY\u0016\u001cG/[8o\u0013\rq\u0018\u0011\u0003\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006L1aHA\u0010\u0011\u001d\tY#a\u0002A\u0002]\tQ!];fefDa\u0001QA\u0004\u0001\u0004\t\u0005bBA\u0019\u0001\u0011E\u00111G\u0001\u0018Kb\u001cW\r\u001d;j_:4%o\\7Ti\u0006$Xo]\"pI\u0016$\u0002\"!\u000e\u0002<\u0005\u0015\u0013\u0011\n\t\u0004\u0017\u0005]\u0012bAA\u001d\u0005\tqqK]5uK\u0016C8-\u001a9uS>t\u0007\u0002CA\u001f\u0003_\u0001\r!a\u0010\u0002\u0015M$\u0018\r^;t\u0007>$W\rE\u0002\u001a\u0003\u0003J1!a\u0011\u001b\u0005\rIe\u000e\u001e\u0005\b\u0003\u000f\ny\u00031\u0001\u0018\u0003\r\u0019HO\u001d\u0005\u000b\u0003\u0017\ny\u0003%AA\u0002\u00055\u0013!\u0003;ie><\u0018M\u00197f!\r1\u0017qJ\u0005\u0004\u0003#j'!\u0003+ie><\u0018M\u00197f\u0011%\t)\u0006AI\u0001\n\u0003\t9&A\bxe&$X\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tIFK\u0002B\u00037Z#!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003OR\u0012AC1o]>$\u0018\r^5p]&!\u00111NA1\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003_\u0002\u0011\u0013!C\u0001\u0003c\nqb\u001e:ji\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003gR3aVA.\u0011%\t9\bAI\u0001\n\u0003\tI(A\bxe&$X\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tYHK\u0002\u0018\u00037B\u0011\"a \u0001#\u0003%I!a\u0016\u0002=\t,\u0018\u000e\u001c3Xe&$X\rU1sC6,G/\u001a:tI\u0011,g-Y;mi\u0012\u0012\u0004\"CAB\u0001E\u0005I\u0011BA9\u0003y\u0011W/\u001b7e/JLG/\u001a)be\u0006lW\r^3sg\u0012\"WMZ1vYR$3\u0007C\u0005\u0002\b\u0002\t\n\u0011\"\u0003\u0002z\u0005q\"-^5mI^\u0013\u0018\u000e^3QCJ\fW.\u001a;feN$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0003\u0017\u0003\u0011\u0013!C\t\u0003\u001b\u000b\u0011%\u001a=dKB$\u0018n\u001c8Ge>l7\u000b^1ukN\u001cu\u000eZ3%I\u00164\u0017-\u001e7uIM*\"!a$+\t\u00055\u00131\f\u0005\n\u0003'\u0003\u0011\u0013!C\u0001\u0003/\n1CY;mW^\u0013\u0018\u000e^3%I\u00164\u0017-\u001e7uIIB\u0011\"a&\u0001#\u0003%\t!!\u001d\u0002'\t,Hn[,sSR,G\u0005Z3gCVdG\u000fJ\u001a\t\u0013\u0005m\u0005!%A\u0005\u0002\u0005e\u0014a\u00052vY.<&/\u001b;fI\u0011,g-Y;mi\u0012\"\u0004")
public class Database
extends InfluxDB
implements RetentionPolicyManagement,
DatabaseManagement {
    private final String databaseName;
    private final HttpClient httpClient;

    @Override
    public Future<QueryResult> create() {
        return DatabaseManagement$class.create(this);
    }

    @Override
    public Future<QueryResult> drop() {
        return DatabaseManagement$class.drop(this);
    }

    @Override
    public Future<Object> exists() {
        return DatabaseManagement$class.exists(this);
    }

    @Override
    public Future<QueryResult> createRetentionPolicy(String name, String duration, int replication, boolean bl) {
        return RetentionPolicyManagement$class.createRetentionPolicy(this, name, duration, replication, bl);
    }

    @Override
    public Future<QueryResult> showRetentionPolicies() {
        return RetentionPolicyManagement$class.showRetentionPolicies(this);
    }

    @Override
    public Future<QueryResult> dropRetentionPolicy(String name) {
        return RetentionPolicyManagement$class.dropRetentionPolicy(this, name);
    }

    @Override
    public Future<QueryResult> alterRetentionPolicy(String name, String duration, int replication, boolean bl) {
        return RetentionPolicyManagement$class.alterRetentionPolicy(this, name, duration, replication, bl);
    }

    @Override
    public String alterRetentionPolicy$default$2() {
        return RetentionPolicyManagement$class.alterRetentionPolicy$default$2(this);
    }

    @Override
    public int alterRetentionPolicy$default$3() {
        return RetentionPolicyManagement$class.alterRetentionPolicy$default$3(this);
    }

    @Override
    public boolean alterRetentionPolicy$default$4() {
        return RetentionPolicyManagement$class.alterRetentionPolicy$default$4(this);
    }

    public String databaseName() {
        return this.databaseName;
    }

    public Future<Object> write(Point point, Parameter.Precision.Precision precision, Parameter.Consistency.Consistency consistency, String retentionPolicy) {
        return this.executeWrite(point.serialize(), precision, consistency, retentionPolicy);
    }

    public Parameter.Precision.Precision write$default$2() {
        return null;
    }

    public Parameter.Consistency.Consistency write$default$3() {
        return null;
    }

    public String write$default$4() {
        return null;
    }

    public Future<Object> bulkWrite(List<Point> points2, Parameter.Precision.Precision precision, Parameter.Consistency.Consistency consistency, String retentionPolicy) {
        String payload = ((TraversableOnce)points2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Point x$1) {
                return x$1.serialize();
            }
        }, List$.MODULE$.canBuildFrom())).mkString("\n");
        return this.executeWrite(payload, precision, consistency, retentionPolicy);
    }

    public Parameter.Precision.Precision bulkWrite$default$2() {
        return null;
    }

    public Parameter.Consistency.Consistency bulkWrite$default$3() {
        return null;
    }

    public String bulkWrite$default$4() {
        return null;
    }

    private Future<Object> executeWrite(String payload, Parameter.Precision.Precision precision, Parameter.Consistency.Consistency consistency, String retentionPolicy) {
        Map<String, String> params = this.buildWriteParameters(this.databaseName(), precision, consistency, retentionPolicy);
        return this.httpClient.post("/write", params, payload).recover((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Database $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof HttpException) {
                    HttpException httpException = (HttpException)A1;
                    throw this.$outer.exceptionFromStatusCode(httpException.code(), "Error during write", httpException);
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof HttpException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.ec()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Database $outer;

            public final boolean apply(HttpClient.HttpResponse result) {
                if (result.code() != 204) {
                    throw this.$outer.exceptionFromStatusCode(result.code(), new StringBuilder().append((Object)"Error during write: ").append((Object)result.content()).toString(), this.$outer.exceptionFromStatusCode$default$3());
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.ec());
    }

    private Map<String, String> buildWriteParameters(String databaseName, Parameter.Precision.Precision precision, Parameter.Consistency.Consistency consistency, String retentionPolicy) {
        List params = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"db", (Object)databaseName), new Tuple2((Object)"precision", (Object)precision), new Tuple2((Object)"consistency", (Object)consistency), new Tuple2((Object)"rp", (Object)retentionPolicy)}));
        return ((TraversableOnce)((List)params.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x$2) {
                return x$2._2() == null;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, Object> r) {
                return new Tuple2(r._1(), (Object)r._2().toString());
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Parameter.Precision.Precision buildWriteParameters$default$2() {
        return null;
    }

    private Parameter.Consistency.Consistency buildWriteParameters$default$3() {
        return null;
    }

    private String buildWriteParameters$default$4() {
        return null;
    }

    @Override
    public Map<String, String> buildQueryParameters(String query2, Parameter.Precision.Precision precision) {
        return super.buildQueryParameters(query2, precision).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"db"), (Object)this.databaseName()));
    }

    public WriteException exceptionFromStatusCode(int statusCode, String str, Throwable throwable) {
        WriteException writeException;
        int n = statusCode;
        switch (n) {
            default: {
                if (400 <= n && n <= 499) {
                    writeException = new MalformedRequestException(str, throwable);
                    break;
                }
                if (500 <= n && n <= 599) {
                    writeException = new ServerUnavailableException(str, throwable);
                    break;
                }
                writeException = new UnknownErrorException(str, throwable);
                break;
            }
            case 404: {
                writeException = new DatabaseNotFoundException(str, throwable);
                break;
            }
            case 200: {
                writeException = new RequestNotCompletedException(str, throwable);
            }
        }
        return writeException;
    }

    public Throwable exceptionFromStatusCode$default$3() {
        return null;
    }

    public Database(String databaseName, HttpClient httpClient) {
        this.databaseName = databaseName;
        this.httpClient = httpClient;
        super(httpClient);
        RetentionPolicyManagement$class.$init$(this);
        DatabaseManagement$class.$init$(this);
    }
}

