/*
 * Decompiled with CFR 0.152.
 */
package com.paulgoldbaum.influxdbclient;

import com.paulgoldbaum.influxdbclient.InfluxDB;
import com.paulgoldbaum.influxdbclient.Privilege;
import com.paulgoldbaum.influxdbclient.QueryResult;
import com.paulgoldbaum.influxdbclient.Record;
import com.paulgoldbaum.influxdbclient.Series;
import com.paulgoldbaum.influxdbclient.UserManagement$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;

public abstract class UserManagement$class {
    public static Future createUser(InfluxDB $this, String username, String password, boolean isClusterAdmin) {
        String queryString = new StringOps(Predef$.MODULE$.augmentString("CREATE USER %s WITH PASSWORD '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username, password}));
        if (isClusterAdmin) {
            queryString = new StringBuilder().append((Object)queryString).append((Object)" WITH ALL PRIVILEGES").toString();
        }
        return $this.exec(queryString);
    }

    public static boolean createUser$default$3(InfluxDB $this) {
        return false;
    }

    public static Future dropUser(InfluxDB $this, String username) {
        String queryString = new StringBuilder().append((Object)"DROP USER ").append((Object)username).toString();
        return $this.exec(queryString);
    }

    public static Future showUsers(InfluxDB $this) {
        return $this.query("SHOW USERS", $this.query$default$2());
    }

    public static Future setUserPassword(InfluxDB $this, String username, String password) {
        return $this.exec(new StringOps(Predef$.MODULE$.augmentString("SET PASSWORD FOR %s='%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username, password})));
    }

    public static Future grantPrivileges(InfluxDB $this, String username, String database, Privilege privilege) {
        return $this.exec(new StringOps(Predef$.MODULE$.augmentString("GRANT %s ON %s TO %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{privilege, database, username})));
    }

    public static Future revokePrivileges(InfluxDB $this, String username, String database, Privilege privilege) {
        return $this.exec(new StringOps(Predef$.MODULE$.augmentString("REVOKE %s ON %s FROM %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{privilege, database, username})));
    }

    public static Future makeClusterAdmin(InfluxDB $this, String username) {
        return $this.exec(new StringOps(Predef$.MODULE$.augmentString("GRANT ALL PRIVILEGES TO %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})));
    }

    public static Future userIsClusterAdmin(InfluxDB $this, String username) {
        return $this.showUsers().map((Function1)new Serializable($this, username){
            public static final long serialVersionUID = 0L;
            public final String username$1;

            public final boolean apply(QueryResult result) {
                return ((Series)result.series().head()).records().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ UserManagement$.anonfun.userIsClusterAdmin.1 $outer;

                    public final boolean apply(Record record) {
                        Object object = record.apply("user");
                        String string = this.$outer.username$1;
                        return !(object != null ? !object.equals(string) : string != null) && BoxesRunTime.equals((Object)record.apply("admin"), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.username$1 = username$1;
            }
        }, $this.ec());
    }

    public static String escapePassword(InfluxDB $this, String password) {
        return password.replaceAll("(['\n])", "\\\\$1");
    }

    public static void $init$(InfluxDB $this) {
    }
}

