/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.telegram.bot.client.http;

import com.payneteasy.telegram.bot.client.http.SimpleHttpResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHttpClient.class);
    private HttpURLConnection connection;
    private InputStream inputStream;

    public void connect(String aUrl, int aConnectionTimeoutMs, int aReadTimeoutMs, String aMethod) throws IOException {
        LOG.debug("Sending {} to {} with {}ms, {}ms ...", new Object[]{aMethod, aUrl, aConnectionTimeoutMs, aReadTimeoutMs});
        this.connection = (HttpURLConnection)new URL(aUrl).openConnection();
        this.connection.setReadTimeout(aReadTimeoutMs);
        this.connection.setConnectTimeout(aConnectionTimeoutMs);
        this.connection.setRequestMethod(aMethod);
        this.connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    public void sendHeader(String aName, String aValue) {
        this.connection.setRequestProperty(aName, aValue);
    }

    public SimpleHttpResponse fetchResponse() throws IOException {
        int responseCode = this.connection.getResponseCode();
        this.inputStream = responseCode >= 400 ? this.connection.getErrorStream() : this.connection.getInputStream();
        int length = this.connection.getHeaderFieldInt("Content-Length", 0);
        LOG.debug("Fetching response with {} status and {} length", (Object)responseCode, (Object)length);
        byte[] response = IOUtils.readFully((InputStream)this.inputStream, (int)length);
        return new SimpleHttpResponse(responseCode, this.connection.getResponseMessage(), response);
    }

    public void sendBody(byte[] aBody) throws IOException {
        this.connection.setDoOutput(true);
        this.connection.getOutputStream().write(aBody);
    }
}

