/*
 * Decompiled with CFR 0.152.
 */
package com.payneteasy.telegram.bot.client.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.payneteasy.telegram.bot.client.http.HttpClientTimeouts;
import com.payneteasy.telegram.bot.client.http.ITelegramHttpClient;
import com.payneteasy.telegram.bot.client.http.SimpleHttpClient;
import com.payneteasy.telegram.bot.client.http.SimpleHttpResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramHttpClientImpl
implements ITelegramHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramHttpClientImpl.class);
    private final String baseUrl;
    private final String token;
    private final HttpClientTimeouts timeouts;
    private final Gson gson;

    public TelegramHttpClientImpl(String baseUrl, String token, HttpClientTimeouts timeouts, Gson gson) {
        this.baseUrl = baseUrl;
        this.token = token;
        this.timeouts = timeouts;
        this.gson = gson;
    }

    public TelegramHttpClientImpl(String token) {
        this("https://api.telegram.org/bot", token, new HttpClientTimeouts(30000, 30000, 30000), new GsonBuilder().setPrettyPrinting().create());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T get(String aMethodName, Class<T> aResponseClass) {
        try (SimpleHttpClient client = new SimpleHttpClient();){
            client.connect(this.baseUrl + this.token + "/" + aMethodName, this.timeouts.getConnectionMs(), this.timeouts.getReadMs(), "GET");
            client.sendHeader("Content-Type", "application/json");
            SimpleHttpResponse response = client.fetchResponse();
            if (response.getStatusCode() != 200) {
                throw new IllegalStateException(new String(response.getBody(), StandardCharsets.UTF_8));
            }
            Object object = this.gson.fromJson(new String(response.getBody(), StandardCharsets.UTF_8), aResponseClass);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot invoke " + aMethodName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R, T> T post(String aMethodName, R aRequest, Class<T> aResponseClass) {
        try (SimpleHttpClient client = new SimpleHttpClient();){
            client.connect(this.baseUrl + this.token + "/" + aMethodName, this.timeouts.getConnectionMs(), this.timeouts.getReadMs(), "GET");
            client.sendHeader("Content-Type", "application/json");
            client.sendBody(this.gson.toJson(aRequest).getBytes(StandardCharsets.UTF_8));
            SimpleHttpResponse response = client.fetchResponse();
            if (response.getStatusCode() != 200) {
                throw new IllegalStateException(new String(response.getBody(), StandardCharsets.UTF_8));
            }
            Object object = this.gson.fromJson(new String(response.getBody(), StandardCharsets.UTF_8), aResponseClass);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot invoke " + aMethodName, e);
        }
    }
}

