/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.paypal.android.sdk.onetouch.core.enums.ResponseType;
import com.paypal.android.sdk.onetouch.core.enums.ResultType;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public final class Result
implements Parcelable {
    private static final String TAG = Result.class.getSimpleName();
    private final String mEnvironment;
    private final ResultType mResultType;
    private final ResponseType mResponseType;
    private final JSONObject mResponse;
    private final String mUserEmail;
    private final Throwable mError;
    public static final Parcelable.Creator<Result> CREATOR = new Parcelable.Creator<Result>(){

        public Result createFromParcel(Parcel source) {
            return new Result(source);
        }

        public Result[] newArray(int size) {
            return new Result[size];
        }
    };

    public Result(String environment, ResponseType responseType, JSONObject response, String userEmail) {
        this(ResultType.Success, environment, responseType, response, userEmail, null);
    }

    public Result(Throwable error) {
        this(ResultType.Error, null, null, null, null, error);
    }

    public Result() {
        this(ResultType.Cancel, null, null, null, null, null);
    }

    private Result(ResultType resultType, String environment, ResponseType responseType, JSONObject response, String userEmail, Throwable error) {
        this.mEnvironment = environment;
        this.mResultType = resultType;
        this.mResponseType = responseType;
        this.mResponse = response;
        this.mUserEmail = userEmail;
        this.mError = error;
    }

    public ResultType getResultType() {
        return this.mResultType;
    }

    public JSONObject getResponse() {
        try {
            JSONObject client = new JSONObject();
            client.put("environment", (Object)this.mEnvironment);
            JSONObject response = new JSONObject();
            response.put("client", (Object)client);
            if (null != this.mResponse) {
                JSONObject result = this.mResponse;
                response.put("response", (Object)result);
            }
            if (null != this.mResponseType) {
                response.put("response_type", (Object)this.mResponseType.name());
            }
            if (null != this.mUserEmail) {
                JSONObject user = new JSONObject();
                user.put("display_string", (Object)this.mUserEmail);
                response.put("user", (Object)user);
            }
            return response;
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error encoding JSON", (Throwable)e);
            return null;
        }
    }

    public Throwable getError() {
        return this.mError;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mEnvironment);
        dest.writeSerializable((Serializable)((Object)this.mResultType));
        dest.writeSerializable((Serializable)((Object)this.mResponseType));
        dest.writeString(this.mResponse == null ? null : this.mResponse.toString());
        dest.writeString(this.mUserEmail);
        dest.writeSerializable((Serializable)this.mError);
    }

    private Result(Parcel in) {
        this.mEnvironment = in.readString();
        this.mResultType = (ResultType)((Object)in.readSerializable());
        this.mResponseType = (ResponseType)((Object)in.readSerializable());
        JSONObject jsonResponse = null;
        try {
            String jsonString = in.readString();
            if (null != jsonString) {
                jsonResponse = new JSONObject(jsonString);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to read parceled JSON for mResponse", (Throwable)e);
        }
        this.mResponse = jsonResponse;
        this.mUserEmail = in.readString();
        this.mError = (Throwable)in.readSerializable();
    }
}

