/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.config;

import com.paypal.android.sdk.onetouch.core.config.BillingAgreementRecipe;
import com.paypal.android.sdk.onetouch.core.config.CheckoutRecipe;
import com.paypal.android.sdk.onetouch.core.config.OAuth2Recipe;
import com.paypal.android.sdk.onetouch.core.enums.RequestTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class OtcConfiguration {
    private final ArrayList<OAuth2Recipe> mOauth2RecipesInDecreasingPriorityOrder = new ArrayList();
    private final ArrayList<CheckoutRecipe> mCheckoutRecipesInDecreasingPriorityOrder = new ArrayList();
    private final ArrayList<BillingAgreementRecipe> mBillingAgreementRecipesInDecreasingPriorityOrder = new ArrayList();
    private String mFileTimestamp;

    public OtcConfiguration withOauth2Recipe(OAuth2Recipe recipe) {
        this.mOauth2RecipesInDecreasingPriorityOrder.add(recipe);
        return this;
    }

    public OtcConfiguration fileTimestamp(String fileTimestamp) {
        this.mFileTimestamp = fileTimestamp;
        return this;
    }

    public String getFileTimestamp() {
        return this.mFileTimestamp;
    }

    public OAuth2Recipe getBrowserOauth2Config(Set<String> scopes) {
        for (OAuth2Recipe recipe : this.mOauth2RecipesInDecreasingPriorityOrder) {
            if (recipe.getTarget() != RequestTarget.browser || !recipe.isValidForScopes(scopes)) continue;
            return recipe;
        }
        return null;
    }

    public CheckoutRecipe getBrowserCheckoutConfig() {
        for (CheckoutRecipe recipe : this.mCheckoutRecipesInDecreasingPriorityOrder) {
            if (recipe.getTarget() != RequestTarget.browser) continue;
            return recipe;
        }
        return null;
    }

    public BillingAgreementRecipe getBrowserBillingAgreementConfig() {
        for (BillingAgreementRecipe recipe : this.mBillingAgreementRecipesInDecreasingPriorityOrder) {
            if (recipe.getTarget() != RequestTarget.browser) continue;
            return recipe;
        }
        return null;
    }

    public List<OAuth2Recipe> getOauth2Recipes() {
        return new ArrayList<OAuth2Recipe>(this.mOauth2RecipesInDecreasingPriorityOrder);
    }

    public void withCheckoutRecipe(CheckoutRecipe recipe) {
        this.mCheckoutRecipesInDecreasingPriorityOrder.add(recipe);
    }

    public List<CheckoutRecipe> getCheckoutRecipes() {
        return new ArrayList<CheckoutRecipe>(this.mCheckoutRecipesInDecreasingPriorityOrder);
    }

    public void withBillingAgreementRecipe(BillingAgreementRecipe recipe) {
        this.mBillingAgreementRecipesInDecreasingPriorityOrder.add(recipe);
    }

    public List<BillingAgreementRecipe> getBillingAgreementRecipes() {
        return new ArrayList<BillingAgreementRecipe>(this.mBillingAgreementRecipesInDecreasingPriorityOrder);
    }
}

