/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.paypal.android.sdk.onetouch.core.enums.ResponseType;
import com.paypal.android.sdk.onetouch.core.enums.ResultType;
import org.json.JSONException;
import org.json.JSONObject;

public final class Result
implements Parcelable {
    private static final String TAG = Result.class.getSimpleName();
    private final String mEnvironment;
    private final ResultType mResultType;
    private final ResponseType mResponseType;
    private final JSONObject mResponse;
    private final String mUserEmail;
    private final Throwable mError;
    public static final Parcelable.Creator<Result> CREATOR = new Parcelable.Creator<Result>(){

        public Result createFromParcel(Parcel source) {
            return new Result(source);
        }

        public Result[] newArray(int size) {
            return new Result[size];
        }
    };

    public Result(String environment, ResponseType responseType, JSONObject response, String userEmail) {
        this(ResultType.Success, environment, responseType, response, userEmail, null);
    }

    public Result(Throwable error) {
        this(ResultType.Error, null, null, null, null, error);
    }

    public Result() {
        this(ResultType.Cancel, null, null, null, null, null);
    }

    private Result(ResultType resultType, String environment, ResponseType responseType, JSONObject response, String userEmail, Throwable error) {
        this.mEnvironment = environment;
        this.mResultType = resultType;
        this.mResponseType = responseType;
        this.mResponse = response;
        this.mUserEmail = userEmail;
        this.mError = error;
    }

    public ResultType getResultType() {
        return this.mResultType;
    }

    public JSONObject getResponse() {
        try {
            JSONObject client = new JSONObject();
            client.put("environment", (Object)this.mEnvironment);
            client.put("paypal_sdk_version", (Object)"2.2.0-3-gdf1feae-dirty");
            client.put("platform", (Object)"Android");
            client.put("product_name", (Object)"PayPalOneTouch-Android");
            JSONObject response = new JSONObject();
            response.put("client", (Object)client);
            if (null != this.mResponse) {
                JSONObject result = this.mResponse;
                response.put("response", (Object)result);
            }
            if (null != this.mResponseType) {
                response.put("response_type", (Object)this.mResponseType.name());
            }
            if (null != this.mUserEmail) {
                JSONObject user = new JSONObject();
                user.put("display_string", (Object)this.mUserEmail);
                response.put("user", (Object)user);
            }
            return response;
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error encoding JSON", (Throwable)e);
            return null;
        }
    }

    public Throwable getError() {
        return this.mError;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.mEnvironment);
        dest.writeValue((Object)this.mResultType);
        dest.writeValue((Object)this.mResponseType);
        if (null != this.mResponse) {
            dest.writeValue((Object)this.mResponse.toString());
        } else {
            dest.writeValue(null);
        }
        dest.writeValue((Object)this.mUserEmail);
        dest.writeValue((Object)this.mError);
    }

    private Result(Parcel in) {
        this.mEnvironment = (String)in.readValue(null);
        this.mResultType = (ResultType)((Object)in.readValue(ResultType.class.getClassLoader()));
        this.mResponseType = (ResponseType)((Object)in.readValue(ResponseType.class.getClassLoader()));
        JSONObject jsonResponse = null;
        try {
            String jsonString = (String)in.readValue(null);
            if (null != jsonString) {
                jsonResponse = new JSONObject(jsonString);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to read parceled JSON for mResponse", (Throwable)e);
        }
        this.mResponse = jsonResponse;
        this.mUserEmail = (String)in.readValue(null);
        this.mError = (Throwable)in.readValue(null);
    }
}

