/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.paypal.android.sdk.onetouch.core.CheckoutRequest;
import com.paypal.android.sdk.onetouch.core.config.BillingAgreementRecipe;
import com.paypal.android.sdk.onetouch.core.config.OtcConfiguration;
import com.paypal.android.sdk.onetouch.core.config.Recipe;
import com.paypal.android.sdk.onetouch.core.enums.RequestTarget;

public class BillingAgreementRequest
extends CheckoutRequest {
    public static final Parcelable.Creator<BillingAgreementRequest> CREATOR = new Parcelable.Creator<BillingAgreementRequest>(){

        public BillingAgreementRequest[] newArray(int size) {
            return new BillingAgreementRequest[size];
        }

        public BillingAgreementRequest createFromParcel(Parcel source) {
            return new BillingAgreementRequest(source);
        }
    };

    @Override
    public BillingAgreementRequest pairingId(String pairingId) {
        super.pairingId(pairingId);
        return this;
    }

    @Override
    public BillingAgreementRequest approvalURL(String approvalURL) {
        super.approvalURL(approvalURL);
        return this;
    }

    @Override
    public Recipe getRecipeToExecute(Context context, OtcConfiguration config) {
        for (BillingAgreementRecipe recipe : config.getBillingAgreementRecipes()) {
            String browserSwitchUrl;
            if (!(RequestTarget.wallet == recipe.getTarget() ? recipe.isValidAppTarget(context) : RequestTarget.browser == recipe.getTarget() && recipe.isValidBrowserTarget(context, browserSwitchUrl = this.getBrowserSwitchUrl(context, config)))) continue;
            return recipe;
        }
        return null;
    }

    public BillingAgreementRequest() {
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getClientMetadataId());
        dest.writeString(this.getClientId());
        dest.writeString(this.getEnvironment());
        dest.writeString(this.mApprovalUrl);
        dest.writeString(this.mTokenQueryParamKey);
    }

    private BillingAgreementRequest(Parcel source) {
        this.clientMetadataId(source.readString());
        this.clientId(source.readString());
        this.environment(source.readString());
        this.mApprovalUrl = source.readString();
        this.mTokenQueryParamKey = source.readString();
    }
}

