/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Base64;
import com.braintreepayments.api.Json;
import com.paypal.android.sdk.onetouch.core.PayPalOneTouchCore;
import com.paypal.android.sdk.onetouch.core.Request;
import com.paypal.android.sdk.onetouch.core.Result;
import com.paypal.android.sdk.onetouch.core.base.ContextInspector;
import com.paypal.android.sdk.onetouch.core.base.DeviceInspector;
import com.paypal.android.sdk.onetouch.core.config.ConfigEndpoint;
import com.paypal.android.sdk.onetouch.core.config.OAuth2Recipe;
import com.paypal.android.sdk.onetouch.core.config.OtcConfiguration;
import com.paypal.android.sdk.onetouch.core.config.Recipe;
import com.paypal.android.sdk.onetouch.core.encryption.EncryptionUtils;
import com.paypal.android.sdk.onetouch.core.encryption.OtcCrypto;
import com.paypal.android.sdk.onetouch.core.enums.Protocol;
import com.paypal.android.sdk.onetouch.core.enums.RequestTarget;
import com.paypal.android.sdk.onetouch.core.enums.ResponseType;
import com.paypal.android.sdk.onetouch.core.exception.BrowserSwitchException;
import com.paypal.android.sdk.onetouch.core.exception.InvalidEncryptionDataException;
import com.paypal.android.sdk.onetouch.core.exception.ResponseParsingException;
import com.paypal.android.sdk.onetouch.core.fpti.TrackingPoint;
import com.paypal.android.sdk.onetouch.core.network.EnvironmentManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class AuthorizationRequest
extends Request<AuthorizationRequest>
implements Parcelable {
    private final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private final OtcCrypto mOtcCrypto = new OtcCrypto();
    private final HashSet<String> mScopes;
    private final HashMap<String, String> mAdditionalPayloadAttributes;
    private final String mMsgGuid;
    private final byte[] mEncryptionKey;
    private String mPrivacyUrl;
    private String mUserAgreementUrl;
    public static final Parcelable.Creator<AuthorizationRequest> CREATOR = new Parcelable.Creator<AuthorizationRequest>(){

        public AuthorizationRequest[] newArray(int size) {
            return new AuthorizationRequest[size];
        }

        public AuthorizationRequest createFromParcel(Parcel source) {
            return new AuthorizationRequest(source);
        }
    };

    public AuthorizationRequest(Context context) {
        this.clientMetadataId(PayPalOneTouchCore.getClientMetadataId(context));
        this.mMsgGuid = UUID.randomUUID().toString();
        this.mEncryptionKey = this.mOtcCrypto.generateRandom256BitKey();
        this.mAdditionalPayloadAttributes = new HashMap();
        this.mScopes = new HashSet();
    }

    public AuthorizationRequest withAdditionalPayloadAttribute(String key, String value) {
        this.mAdditionalPayloadAttributes.put(key, value);
        return this;
    }

    protected Map<String, String> getAdditionalPayloadAttributes() {
        return new HashMap<String, String>(this.mAdditionalPayloadAttributes);
    }

    public AuthorizationRequest withScopeValue(String scopeValue) {
        Matcher matcher = this.WHITESPACE_PATTERN.matcher(scopeValue);
        boolean found = matcher.find();
        if (found) {
            throw new IllegalArgumentException("scopes must be provided individually, with no whitespace");
        }
        this.mScopes.add(scopeValue);
        return this;
    }

    private Set<String> getScopes() {
        return new HashSet<String>(this.mScopes);
    }

    public String getScopeString() {
        return TextUtils.join((CharSequence)" ", this.getScopes());
    }

    public AuthorizationRequest privacyUrl(String privacyUrl) {
        this.mPrivacyUrl = privacyUrl;
        return this;
    }

    public String getPrivacyUrl() {
        return this.mPrivacyUrl;
    }

    public AuthorizationRequest userAgreementUrl(String userAgreementUrl) {
        this.mUserAgreementUrl = userAgreementUrl;
        return this;
    }

    public String getUserAgreementUrl() {
        return this.mUserAgreementUrl;
    }

    @Override
    @Deprecated
    public String getBrowserSwitchUrl() {
        return "";
    }

    @Override
    @Deprecated
    public String getBrowserSwitchUrl(Context context, OtcConfiguration config) throws CertificateException, UnsupportedEncodingException, NoSuchPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, JSONException, BadPaddingException, InvalidEncryptionDataException, InvalidKeyException {
        OAuth2Recipe recipe = config.getBrowserOauth2Config(this.getScopes());
        ConfigEndpoint configEndpoint = recipe.getEndpoint(this.getEnvironment());
        X509Certificate cert = EncryptionUtils.getX509CertificateFromBase64String(configEndpoint.certificate);
        return configEndpoint.url + "?payload=" + URLEncoder.encode(this.buildPayload(context, cert), "utf-8") + "&payloadEnc=" + URLEncoder.encode(this.buildPayloadEnc(cert), "utf-8") + "&x-source=" + context.getPackageName() + "&x-success=" + this.getSuccessUrl() + "&x-cancel=" + this.getCancelUrl();
    }

    @Override
    public Recipe getBrowserSwitchRecipe(OtcConfiguration config) {
        return config.getBrowserOauth2Config(this.getScopes());
    }

    private boolean isValidResponse(String msgGUID) {
        return this.mMsgGuid.equals(msgGUID);
    }

    private String buildPayloadEnc(Certificate cert) throws NoSuchPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidEncryptionDataException, InvalidKeyException, JSONException {
        JSONObject payloadEnc = this.getJsonObjectToEncrypt();
        byte[] output = this.mOtcCrypto.encryptRSAData(payloadEnc.toString().getBytes(), cert);
        return Base64.encodeToString((byte[])output, (int)2);
    }

    private JSONObject getJsonObjectToEncrypt() throws JSONException {
        JSONObject payloadEnc = new JSONObject();
        payloadEnc.put("timestamp", (Object)new RFC3339DateFormat().format(new Date()));
        payloadEnc.put("msg_GUID", (Object)this.mMsgGuid);
        payloadEnc.put("sym_key", (Object)EncryptionUtils.byteArrayToHexString(this.mEncryptionKey));
        String deviceName = DeviceInspector.getDeviceName();
        payloadEnc.put("device_name", (Object)deviceName.substring(0, Math.min(deviceName.length(), 30)));
        return payloadEnc;
    }

    private String buildPayload(Context context, X509Certificate cert) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("version", 3);
            payload.put("client_id", (Object)this.getClientId());
            payload.put("app_name", (Object)DeviceInspector.getApplicationInfoName(context));
            payload.put("environment", (Object)this.getEnvironment());
            payload.put("environment_url", (Object)EnvironmentManager.getEnvironmentUrl(this.getEnvironment()));
            payload.put("scope", (Object)this.getScopeString());
            payload.put("response_type", (Object)"code");
            payload.put("privacy_url", (Object)this.getPrivacyUrl());
            payload.put("agreement_url", (Object)this.getUserAgreementUrl());
            payload.put("client_metadata_id", (Object)this.getClientMetadataId());
            payload.put("key_id", (Object)cert.getSerialNumber());
            payload.put("android_chrome_available", this.isChromeAvailable(context));
            for (Map.Entry<String, String> entry : this.mAdditionalPayloadAttributes.entrySet()) {
                payload.put(entry.getKey(), (Object)entry.getValue());
            }
            return Base64.encodeToString((byte[])payload.toString().getBytes(), (int)2);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isChromeAvailable(Context context) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://www.paypal.com"));
        intent.setPackage("com.android.chrome");
        return intent.resolveActivity(context.getPackageManager()) != null;
    }

    @Override
    public Result parseBrowserResponse(Uri uri) {
        JSONObject payload;
        String status = uri.getLastPathSegment();
        String payloadEnc = uri.getQueryParameter("payloadEnc");
        try {
            payload = new JSONObject(new String(Base64.decode((String)uri.getQueryParameter("payload"), (int)0)));
        }
        catch (IllegalArgumentException | NullPointerException | JSONException e) {
            payload = new JSONObject();
        }
        if (Uri.parse((String)this.getSuccessUrl()).getLastPathSegment().equals(status)) {
            if (!payload.has("msg_GUID")) {
                return new Result(new ResponseParsingException("Response incomplete"));
            }
            if (TextUtils.isEmpty((CharSequence)payloadEnc) || !this.isValidResponse(Json.optString((JSONObject)payload, (String)"msg_GUID", (String)""))) {
                return new Result(new ResponseParsingException("Response invalid"));
            }
            try {
                JSONObject decryptedPayloadEnc = this.getDecryptedPayload(payloadEnc);
                String error = Json.optString((JSONObject)payload, (String)"error", (String)"");
                if (!TextUtils.isEmpty((CharSequence)error) && !"null".equals(error)) {
                    return new Result(new BrowserSwitchException(error));
                }
                return new Result(Json.optString((JSONObject)payload, (String)"environment", (String)""), ResponseType.authorization_code, new JSONObject().put("code", (Object)decryptedPayloadEnc.getString("payment_code")), decryptedPayloadEnc.getString("email"));
            }
            catch (InvalidEncryptionDataException | IllegalArgumentException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | JSONException e) {
                return new Result(new ResponseParsingException(e));
            }
        }
        if (Uri.parse((String)this.getCancelUrl()).getLastPathSegment().equals(status)) {
            String error = Json.optString((JSONObject)payload, (String)"error", (String)"");
            if (!TextUtils.isEmpty((CharSequence)error) && !"null".equals(error)) {
                return new Result(new BrowserSwitchException(error));
            }
            return new Result();
        }
        return new Result(new ResponseParsingException("Response uri invalid"));
    }

    @Override
    @Deprecated
    public Result parseBrowserResponse(ContextInspector contextInspector, Uri uri) {
        return this.parseBrowserResponse(uri);
    }

    @Override
    public boolean validateV1V2Response(Bundle extras) {
        return true;
    }

    @Override
    public boolean validateV1V2Response(ContextInspector contextInspector, Bundle extras) {
        return this.validateV1V2Response(extras);
    }

    @Override
    public Recipe getRecipeToExecute(Context context, OtcConfiguration config) {
        for (OAuth2Recipe recipe : config.getOauth2Recipes()) {
            if (!recipe.isValidForScopes(this.getScopes())) continue;
            if (RequestTarget.wallet == recipe.getTarget()) {
                if (!recipe.isValidAppTarget(context)) continue;
                return recipe;
            }
            if (RequestTarget.browser != recipe.getTarget()) continue;
            try {
                String browserSwitchUrl = this.getBrowserSwitchUrl(context, config);
                if (!recipe.isValidBrowserTarget(context, browserSwitchUrl)) continue;
                return recipe;
            }
            catch (InvalidEncryptionDataException | UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | JSONException throwable) {
            }
        }
        return null;
    }

    @Override
    public void trackFpti(Context context, TrackingPoint trackingPoint, Protocol protocol) {
        HashMap<String, String> fptiDataBundle = new HashMap<String, String>();
        fptiDataBundle.put("clid", this.getClientId());
        PayPalOneTouchCore.getFptiManager(context).trackFpti(trackingPoint, this.getEnvironment(), fptiDataBundle, protocol);
    }

    private JSONObject getDecryptedPayload(String payloadEnc) throws IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchPaddingException, BadPaddingException, InvalidEncryptionDataException, JSONException, IllegalArgumentException {
        byte[] base64PayloadEnc = Base64.decode((String)payloadEnc, (int)0);
        byte[] output = new OtcCrypto().decryptAESCTRData(base64PayloadEnc, this.mEncryptionKey);
        return new JSONObject(new String(output));
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mPrivacyUrl);
        dest.writeString(this.mUserAgreementUrl);
        dest.writeSerializable(this.mScopes);
        dest.writeSerializable(this.mAdditionalPayloadAttributes);
        dest.writeString(this.mMsgGuid);
        dest.writeInt(this.mEncryptionKey.length);
        dest.writeByteArray(this.mEncryptionKey);
    }

    private AuthorizationRequest(Parcel source) {
        super(source);
        this.mPrivacyUrl = source.readString();
        this.mUserAgreementUrl = source.readString();
        this.mScopes = (HashSet)source.readSerializable();
        this.mAdditionalPayloadAttributes = (HashMap)source.readSerializable();
        this.mMsgGuid = source.readString();
        this.mEncryptionKey = new byte[source.readInt()];
        source.readByteArray(this.mEncryptionKey);
    }

    private class RFC3339DateFormat
    extends SimpleDateFormat {
        RFC3339DateFormat() {
            super("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        }
    }
}

