/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.paypal.android.sdk.onetouch.core.PayPalOneTouchCore;
import com.paypal.android.sdk.onetouch.core.Request;
import com.paypal.android.sdk.onetouch.core.Result;
import com.paypal.android.sdk.onetouch.core.base.ContextInspector;
import com.paypal.android.sdk.onetouch.core.config.CheckoutRecipe;
import com.paypal.android.sdk.onetouch.core.config.OtcConfiguration;
import com.paypal.android.sdk.onetouch.core.config.Recipe;
import com.paypal.android.sdk.onetouch.core.enums.Protocol;
import com.paypal.android.sdk.onetouch.core.enums.RequestTarget;
import com.paypal.android.sdk.onetouch.core.enums.ResponseType;
import com.paypal.android.sdk.onetouch.core.exception.BrowserSwitchException;
import com.paypal.android.sdk.onetouch.core.exception.ResponseParsingException;
import com.paypal.android.sdk.onetouch.core.fpti.TrackingPoint;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckoutRequest
extends Request<CheckoutRequest>
implements Parcelable {
    private static final String PREFS_HERMES_TOKEN = "com.paypal.otc.hermes.token";
    private static final String TOKEN_QUERY_PARAM_KEY_TOKEN = "token";
    private static final String TOKEN_QUERY_PARAM_KEY_BA_TOKEN = "ba_token";
    protected String mApprovalUrl;
    protected String mTokenQueryParamKey;
    private String mPairingId;
    public static final Parcelable.Creator<CheckoutRequest> CREATOR = new Parcelable.Creator<CheckoutRequest>(){

        public CheckoutRequest[] newArray(int size) {
            return new CheckoutRequest[size];
        }

        public CheckoutRequest createFromParcel(Parcel source) {
            return new CheckoutRequest(source);
        }
    };

    public CheckoutRequest() {
        this.mTokenQueryParamKey = TOKEN_QUERY_PARAM_KEY_TOKEN;
    }

    public String getPairingId() {
        return this.mPairingId;
    }

    public CheckoutRequest pairingId(String pairingId) {
        this.mPairingId = pairingId;
        return this;
    }

    public CheckoutRequest approvalURL(String approvalURL) {
        this.mApprovalUrl = approvalURL;
        this.selectTokenQueryParamKey(approvalURL);
        return this;
    }

    private void selectTokenQueryParamKey(String url) {
        this.mTokenQueryParamKey = !TextUtils.isEmpty((CharSequence)url) && url.contains(TOKEN_QUERY_PARAM_KEY_BA_TOKEN) ? TOKEN_QUERY_PARAM_KEY_BA_TOKEN : TOKEN_QUERY_PARAM_KEY_TOKEN;
    }

    @Override
    public String getBrowserSwitchUrl(Context context, OtcConfiguration config) {
        return this.mApprovalUrl;
    }

    @Override
    public Recipe getBrowserSwitchRecipe(OtcConfiguration config) {
        return config.getBrowserCheckoutConfig();
    }

    @Override
    public void persistRequiredFields(ContextInspector contextInspector) {
        contextInspector.setPreference(PREFS_HERMES_TOKEN, Uri.parse((String)this.mApprovalUrl).getQueryParameter(this.mTokenQueryParamKey));
    }

    @Override
    public Result parseBrowserResponse(ContextInspector contextInspector, Uri uri) {
        String status = uri.getLastPathSegment();
        if (!Uri.parse((String)this.getSuccessUrl()).getLastPathSegment().equals(status)) {
            return new Result();
        }
        String persistedXoToken = contextInspector.getStringPreference(PREFS_HERMES_TOKEN);
        String responseXoToken = uri.getQueryParameter(this.mTokenQueryParamKey);
        if (null != responseXoToken && TextUtils.equals((CharSequence)persistedXoToken, (CharSequence)responseXoToken)) {
            try {
                JSONObject response = new JSONObject();
                response.put("webURL", (Object)uri.toString());
                return new Result(null, ResponseType.web, response, null);
            }
            catch (JSONException e) {
                return new Result(new ResponseParsingException(e));
            }
        }
        return new Result(new BrowserSwitchException("The response contained inconsistent data."));
    }

    @Override
    public boolean validateV1V2Response(ContextInspector contextInspector, Bundle extras) {
        String responseXoToken;
        String persistedXoToken = contextInspector.getStringPreference(PREFS_HERMES_TOKEN);
        String webUrl = extras.getString("webURL");
        return null != webUrl && null != (responseXoToken = Uri.parse((String)webUrl).getQueryParameter(this.mTokenQueryParamKey)) && TextUtils.equals((CharSequence)persistedXoToken, (CharSequence)responseXoToken);
    }

    @Override
    public Recipe getRecipeToExecute(Context context, OtcConfiguration config) {
        for (CheckoutRecipe recipe : config.getCheckoutRecipes()) {
            String browserSwitchUrl;
            if (!(RequestTarget.wallet == recipe.getTarget() ? recipe.isValidAppTarget(context) : RequestTarget.browser == recipe.getTarget() && recipe.isValidBrowserTarget(context, browserSwitchUrl = this.getBrowserSwitchUrl(context, config)))) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void trackFpti(Context context, TrackingPoint trackingPoint, Protocol protocol) {
        String ecToken = Uri.parse((String)this.mApprovalUrl).getQueryParameter(this.mTokenQueryParamKey);
        HashMap<String, String> fptiDataBundle = new HashMap<String, String>();
        fptiDataBundle.put("fltk", ecToken);
        fptiDataBundle.put("clid", this.getClientId());
        PayPalOneTouchCore.getFptiManager(context).trackFpti(trackingPoint, this.getEnvironment(), fptiDataBundle, protocol);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getClientMetadataId());
        dest.writeString(this.getClientId());
        dest.writeString(this.getEnvironment());
        dest.writeString(this.mApprovalUrl);
        dest.writeString(this.mTokenQueryParamKey);
    }

    private CheckoutRequest(Parcel source) {
        this.clientMetadataId(source.readString());
        this.clientId(source.readString());
        this.environment(source.readString());
        this.mApprovalUrl = source.readString();
        this.mTokenQueryParamKey = source.readString();
    }
}

