/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.paypal.android.sdk.onetouch.core.Result;
import com.paypal.android.sdk.onetouch.core.base.ContextInspector;
import com.paypal.android.sdk.onetouch.core.config.OtcConfiguration;
import com.paypal.android.sdk.onetouch.core.config.Recipe;
import com.paypal.android.sdk.onetouch.core.enums.Protocol;
import com.paypal.android.sdk.onetouch.core.exception.InvalidEncryptionDataException;
import com.paypal.android.sdk.onetouch.core.fpti.TrackingPoint;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.json.JSONException;

public abstract class Request<T extends Request<T>>
implements Parcelable {
    private String mEnvironment;
    private String mClientId;
    private String mClientMetadataId;
    private String mCancelUrl;
    private String mSuccessUrl;

    public T environment(String environment) {
        this.mEnvironment = environment;
        return (T)this;
    }

    public String getEnvironment() {
        return this.mEnvironment;
    }

    public T clientMetadataId(String clientMetadataId) {
        this.mClientMetadataId = clientMetadataId;
        return (T)this;
    }

    public String getClientMetadataId() {
        return this.mClientMetadataId;
    }

    public T clientId(String clientId) {
        this.mClientId = clientId;
        return (T)this;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public T cancelUrl(String scheme, String host) {
        this.mCancelUrl = scheme + "://" + Request.redirectURLHostAndPath() + host;
        return (T)this;
    }

    public String getCancelUrl() {
        return this.mCancelUrl;
    }

    public T successUrl(String scheme, String host) {
        this.mSuccessUrl = scheme + "://" + Request.redirectURLHostAndPath() + host;
        return (T)this;
    }

    public String getSuccessUrl() {
        return this.mSuccessUrl;
    }

    private static String redirectURLHostAndPath() {
        return "onetouch/v1/";
    }

    public abstract String getBrowserSwitchUrl(Context var1, OtcConfiguration var2) throws CertificateException, UnsupportedEncodingException, NoSuchPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, JSONException, BadPaddingException, InvalidEncryptionDataException, InvalidKeyException;

    public abstract Recipe getBrowserSwitchRecipe(OtcConfiguration var1);

    public abstract void persistRequiredFields(ContextInspector var1);

    public abstract Result parseBrowserResponse(ContextInspector var1, Uri var2);

    public abstract boolean validateV1V2Response(ContextInspector var1, Bundle var2);

    public abstract Recipe getRecipeToExecute(Context var1, OtcConfiguration var2);

    public abstract void trackFpti(Context var1, TrackingPoint var2, Protocol var3);
}

