/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.base;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.paypal.android.sdk.onetouch.core.network.OtcEnvironment;
import java.util.UUID;

public class ContextInspector {
    private static final String INSTALL_GUID = "InstallationGUID";
    private final Context mContext;
    private final SharedPreferences mPreferences;

    public ContextInspector(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.mPreferences = this.mContext.getSharedPreferences(OtcEnvironment.getPrefsFile(), 0);
    }

    public String getInstallationGUID() {
        String existingGUID = this.getStringPreference(INSTALL_GUID);
        if (existingGUID != null) {
            return existingGUID;
        }
        String newGuid = UUID.randomUUID().toString();
        this.setPreference(INSTALL_GUID, newGuid);
        return newGuid;
    }

    public String getStringPreference(String key) {
        return this.mPreferences.getString(key, null);
    }

    public long getLongPreference(String key, long defaultValue) {
        return this.mPreferences.getLong(key, defaultValue);
    }

    public boolean getBooleanPreference(String key, boolean defaultValue) {
        return this.mPreferences.getBoolean(key, defaultValue);
    }

    public void setPreference(String key, String value) {
        this.mPreferences.edit().putString(key, value).apply();
    }

    public void setPreference(String key, long value) {
        this.mPreferences.edit().putLong(key, value).apply();
    }

    public void setPreference(String key, boolean value) {
        this.mPreferences.edit().putBoolean(key, value).apply();
    }

    public Context getContext() {
        return this.mContext;
    }
}

