/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.encryption;

import com.paypal.android.sdk.onetouch.core.encryption.EncryptionUtils;
import com.paypal.android.sdk.onetouch.core.exception.InvalidEncryptionDataException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class OtcCrypto {
    private static final int ENCRYPTION_KEY_SIZE = 32;
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final int NONCE_SIZE = 16;
    private static final String AES_CTR_ALGO = "AES/CTR/NoPadding";
    private static final String RSA_ALGO = "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    private static final int AES_KEY_SIZE = 16;
    private static final int DIGEST_SIZE = 32;
    private static final int MAX_RSA_ENCRYPTABLE_BYTES = 214;

    private byte[] dataDigest(byte[] data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac sha256HMAC = Mac.getInstance(HMAC_SHA256);
        SecretKeySpec digestKey = new SecretKeySpec(key, HMAC_SHA256);
        sha256HMAC.init(digestKey);
        return sha256HMAC.doFinal(data);
    }

    public byte[] generateRandom256BitKey() {
        return EncryptionUtils.generateRandomData(32);
    }

    public byte[] encryptRSAData(byte[] plainData, Certificate certificate) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidEncryptionDataException {
        if (plainData.length > 214) {
            throw new InvalidEncryptionDataException("Data is too large for public key encryption: " + plainData.length + " > " + 214);
        }
        PublicKey publicKey = certificate.getPublicKey();
        Cipher rsaCipher = Cipher.getInstance(RSA_ALGO);
        rsaCipher.init(1, publicKey);
        return rsaCipher.doFinal(plainData);
    }

    public byte[] decryptAESCTRData(byte[] cipherData, byte[] key) throws IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, IllegalArgumentException, InvalidAlgorithmParameterException, NoSuchPaddingException, BadPaddingException, InvalidEncryptionDataException {
        if (cipherData.length < 48) {
            throw new InvalidEncryptionDataException("data is too small");
        }
        byte[] encryptionKey = new byte[16];
        System.arraycopy(key, 0, encryptionKey, 0, 16);
        byte[] digestKey = new byte[16];
        System.arraycopy(key, 16, digestKey, 0, 16);
        byte[] signature = new byte[32];
        System.arraycopy(cipherData, 0, signature, 0, 32);
        byte[] signedData = new byte[cipherData.length - 32];
        System.arraycopy(cipherData, 32, signedData, 0, cipherData.length - 32);
        byte[] digest = this.dataDigest(signedData, digestKey);
        if (!EncryptionUtils.isEqual(digest, signature)) {
            throw new IllegalArgumentException("Signature mismatch");
        }
        byte[] nonceData = new byte[16];
        System.arraycopy(signedData, 0, nonceData, 0, 16);
        IvParameterSpec nonceSpec = new IvParameterSpec(nonceData);
        SecretKeySpec keySpec = new SecretKeySpec(encryptionKey, "AES");
        Cipher cipher = Cipher.getInstance(AES_CTR_ALGO);
        cipher.init(2, (Key)keySpec, nonceSpec);
        return cipher.doFinal(signedData, 16, signedData.length - 16);
    }
}

