/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.network;

public class EnvironmentManager {
    public static final String LIVE = "live";
    public static final String SANDBOX = "sandbox";
    public static final String MOCK = "mock";
    public static final String LIVE_API_M_ENDPOINT = "https://api-m.paypal.com/v1/";
    public static final String SANDBOX_API_M_ENDPOINT = "https://api-m.sandbox.paypal.com/v1/";

    public static boolean isMock(String environmentName) {
        return environmentName.equals(MOCK);
    }

    public static boolean isSandbox(String environmentName) {
        return environmentName.equals(SANDBOX);
    }

    public static boolean isLive(String environmentName) {
        return environmentName.equals(LIVE);
    }

    public static boolean isStage(String environmentName) {
        return !EnvironmentManager.isLive(environmentName) && !EnvironmentManager.isSandbox(environmentName) && !EnvironmentManager.isMock(environmentName);
    }

    public static String getEnvironmentUrl(String environmentName) {
        if (EnvironmentManager.isLive(environmentName)) {
            return LIVE_API_M_ENDPOINT;
        }
        if (EnvironmentManager.isSandbox(environmentName)) {
            return SANDBOX_API_M_ENDPOINT;
        }
        if (EnvironmentManager.isMock(environmentName)) {
            return null;
        }
        return environmentName;
    }
}

