/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.config;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.braintreepayments.api.internal.AppHelper;
import com.braintreepayments.browserswitch.ChromeCustomTabs;
import com.paypal.android.sdk.onetouch.core.enums.Protocol;
import com.paypal.android.sdk.onetouch.core.enums.RequestTarget;
import com.paypal.android.sdk.onetouch.core.sdk.AppSwitchHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public abstract class Recipe<T extends Recipe<T>> {
    private List<String> mTargetPackagesInReversePriorityOrder = new ArrayList<String>();
    private RequestTarget mTarget;
    private Protocol mProtocol;
    private String mTargetIntentAction;
    private Collection<String> mSupportedLocales = new HashSet<String>();

    public T target(RequestTarget target) {
        this.mTarget = target;
        return this.getThis();
    }

    public T protocol(String protocol) {
        this.mProtocol = Protocol.getProtocol(protocol);
        return this.getThis();
    }

    public T targetPackage(String singleTargetPackage) {
        this.mTargetPackagesInReversePriorityOrder.add(singleTargetPackage);
        return this.getThis();
    }

    public List<String> getTargetPackagesInReversePriorityOrder() {
        return new ArrayList<String>(this.mTargetPackagesInReversePriorityOrder);
    }

    public T supportedLocale(String supportedLocale) {
        this.mSupportedLocales.add(supportedLocale);
        return this.getThis();
    }

    public T targetIntentAction(String targetIntentAction) {
        this.mTargetIntentAction = targetIntentAction;
        return this.getThis();
    }

    public String getTargetIntentAction() {
        return this.mTargetIntentAction;
    }

    public RequestTarget getTarget() {
        return this.mTarget;
    }

    protected abstract T getThis();

    public boolean isValidAppTarget(Context context) {
        for (String allowedWalletTarget : this.getTargetPackagesInReversePriorityOrder()) {
            boolean isIntentAvailable = AppHelper.isIntentAvailable((Context)context, (Intent)AppSwitchHelper.createBaseIntent(this.getTargetIntentAction(), allowedWalletTarget));
            String locale = Locale.getDefault().toString();
            boolean isLocaleAllowed = this.mSupportedLocales.isEmpty() || this.mSupportedLocales.contains(locale);
            boolean isSignatureValid = AppSwitchHelper.isSignatureValid(context, allowedWalletTarget);
            if (!isIntentAvailable || !isLocaleAllowed || !isSignatureValid) continue;
            return true;
        }
        return false;
    }

    public boolean isValidBrowserTarget(Context context, String browserSwitchUrl) {
        for (String allowedBrowserPackage : this.getTargetPackagesInReversePriorityOrder()) {
            boolean canBeResolved = Recipe.isValidBrowserTarget(context, browserSwitchUrl, allowedBrowserPackage);
            if (!canBeResolved) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidBrowserTarget(Context context, String browserSwitchUrl, String allowedBrowserPackage) {
        Intent intent = Recipe.getBrowserIntent(context, browserSwitchUrl, allowedBrowserPackage);
        return intent.resolveActivity(context.getPackageManager()) != null;
    }

    public static Intent getBrowserIntent(Context context, String browserSwitchUrl, String allowedBrowserPackage) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)browserSwitchUrl)).addFlags(0x10000000);
        if (!"*".equals(allowedBrowserPackage)) {
            intent.setPackage(allowedBrowserPackage);
        }
        return ChromeCustomTabs.addChromeCustomTabsExtras((Context)context, (Intent)intent);
    }

    public Protocol getProtocol() {
        return this.mProtocol;
    }
}

