/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.encryption;

import android.util.Base64;
import com.paypal.android.sdk.onetouch.core.encryption.PRNGFixes;
import java.io.ByteArrayInputStream;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class EncryptionUtils {
    private static final SecureRandom RANDOM;

    public static byte[] generateRandomData(int size) {
        byte[] output = new byte[size];
        RANDOM.nextBytes(output);
        return output;
    }

    public static X509Certificate getX509CertificateFromBase64String(String certificateBase64) throws CertificateException {
        byte[] certificate = Base64.decode((String)certificateBase64, (int)0);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certificate));
    }

    public static String byteArrayToHexString(byte[] array) {
        if (null == array) {
            return null;
        }
        StringBuilder hexString = new StringBuilder();
        for (byte b : array) {
            int intVal = b & 0xFF;
            if (intVal < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(intVal));
        }
        return hexString.toString().toUpperCase();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static boolean isEqual(byte[] arrayOne, byte[] arrayTwo) {
        if (arrayOne.length != arrayTwo.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < arrayOne.length; ++i) {
            result |= arrayOne[i] ^ arrayTwo[i];
        }
        return result == 0;
    }

    static {
        PRNGFixes.apply();
        RANDOM = new SecureRandom();
    }
}

