/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.fpti;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import com.paypal.android.sdk.data.collector.InstallationIdentifier;
import com.paypal.android.sdk.onetouch.core.base.ContextInspector;
import com.paypal.android.sdk.onetouch.core.base.DeviceInspector;
import com.paypal.android.sdk.onetouch.core.base.URLEncoderHelper;
import com.paypal.android.sdk.onetouch.core.enums.Protocol;
import com.paypal.android.sdk.onetouch.core.fpti.FptiToken;
import com.paypal.android.sdk.onetouch.core.fpti.TrackingPoint;
import com.paypal.android.sdk.onetouch.core.network.EnvironmentManager;
import com.paypal.android.sdk.onetouch.core.network.PayPalHttpClient;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class FptiManager {
    private final ContextInspector mContextInspector;
    private final PayPalHttpClient mHttpClient;
    private FptiToken mToken;

    public FptiManager(ContextInspector contextInspector, PayPalHttpClient httpClient) {
        this.mContextInspector = contextInspector;
        this.mHttpClient = httpClient;
    }

    public void trackFpti(TrackingPoint point, String environmentName, Map<String, String> fptiDataBundle, Protocol protocol) {
        if (EnvironmentManager.isMock(environmentName)) {
            return;
        }
        if (this.mToken == null || !this.mToken.isValid()) {
            this.mToken = new FptiToken();
        }
        long currentTimeInMillis = System.currentTimeMillis();
        String deviceId = URLEncoderHelper.encode(InstallationIdentifier.getInstallationGUID((Context)this.mContextInspector.getContext()));
        String abcde = "mobile:otc:" + point.getCd() + ":" + (null != protocol ? protocol.name() : "");
        String xyz = "Android:" + environmentName + ":";
        String abcdexyz_error = abcde + ":" + xyz + (point.hasError() ? "|error" : "");
        HashMap<String, String> params = new HashMap<String, String>(fptiDataBundle);
        params.put("apid", DeviceInspector.getApplicationInfoName(this.mContextInspector.getContext()) + "|" + "2.6.0" + "|" + this.mContextInspector.getContext().getPackageName());
        params.put("bchn", "otc");
        params.put("bzsr", "mobile");
        params.put("dsid", deviceId);
        params.put("e", "im");
        params.put("g", this.getGmtOffsetInMinutes());
        params.put("lgin", "out");
        params.put("mapv", "2.6.0");
        params.put("mcar", DeviceInspector.getSimOperatorName(this.mContextInspector.getContext()));
        params.put("mdvs", DeviceInspector.getDeviceName());
        params.put("mosv", DeviceInspector.getOs());
        params.put("page", abcdexyz_error);
        params.put("pgrp", abcde);
        params.put("rsta", Locale.getDefault().toString());
        params.put("srce", "otc");
        params.put("sv", "mobile");
        params.put("t", Long.toString(currentTimeInMillis - (long)this.getGMTOffset()));
        params.put("vers", "Android:" + environmentName + ":");
        params.put("vid", this.mToken.mToken);
        try {
            JSONObject actor = new JSONObject();
            actor.accumulate("tracking_visitor_id", (Object)deviceId);
            actor.accumulate("tracking_visit_id", (Object)this.mToken.mToken);
            JSONObject events = new JSONObject();
            events.accumulate("actor", (Object)actor);
            events.accumulate("channel", (Object)"mobile");
            events.accumulate("tracking_event", (Object)Long.toString(currentTimeInMillis));
            events.accumulate("event_params", (Object)this.getEventParams(params));
            this.sendRequest(new JSONObject().accumulate("events", (Object)events).toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private JSONObject getEventParams(Map<String, String> params) throws JSONException {
        JSONObject ret = new JSONObject();
        for (String key : params.keySet()) {
            ret.accumulate(key, (Object)params.get(key));
        }
        return ret;
    }

    @VisibleForTesting
    void sendRequest(final String data) {
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                FptiManager.this.mHttpClient.post("tracking/events", data, null);
            }
        }, (long)((10 + new Random().nextInt(190)) * 1000));
    }

    private int getGMTOffset() {
        return new GregorianCalendar().getTimeZone().getRawOffset();
    }

    private String getGmtOffsetInMinutes() {
        return Integer.toString(this.getGMTOffset() / 1000 / 60);
    }
}

