/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.base;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;

public class ContextInspector {
    private final Context mContext;
    private final SharedPreferences mPreferences;

    public ContextInspector(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.mPreferences = this.mContext.getSharedPreferences("PayPalOTC", 0);
    }

    public String getStringPreference(String key) {
        return this.mPreferences.getString(key, null);
    }

    public long getLongPreference(String key, long defaultValue) {
        return this.mPreferences.getLong(key, defaultValue);
    }

    public boolean getBooleanPreference(String key, boolean defaultValue) {
        return this.mPreferences.getBoolean(key, defaultValue);
    }

    public void setPreference(String key, String value) {
        this.mPreferences.edit().putString(key, value).apply();
    }

    public void setPreference(String key, long value) {
        this.mPreferences.edit().putLong(key, value).apply();
    }

    public void setPreference(String key, boolean value) {
        this.mPreferences.edit().putBoolean(key, value).apply();
    }

    public Context getContext() {
        return this.mContext;
    }
}

