/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.base;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;

public class DeviceInspector {
    public static String getApplicationInfoName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            return packageManager.getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.loadLabel(packageManager).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static String getSimOperatorName(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getSimOperatorName();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static String getDeviceName() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (manufacturer.equalsIgnoreCase("unknown") || model.startsWith(manufacturer)) {
            return model;
        }
        return manufacturer + " " + model;
    }

    public static String getOs() {
        return "Android " + Build.VERSION.RELEASE;
    }
}

