/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.android.sdk.onetouch.core.config;

import com.paypal.android.sdk.onetouch.core.config.ConfigEndpoint;
import com.paypal.android.sdk.onetouch.core.config.Recipe;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OAuth2Recipe
extends Recipe<OAuth2Recipe> {
    static final String DEVELOP = "develop";
    private final Collection<String> mScope = new HashSet<String>();
    private final Map<String, ConfigEndpoint> mEndpoints = new HashMap<String, ConfigEndpoint>();
    private boolean mIsValidForAllScopes;

    @Override
    public OAuth2Recipe getThis() {
        return this;
    }

    public void validForScope(String singleScopeValue) {
        this.mScope.add(singleScopeValue);
    }

    public void withEndpoint(String name, ConfigEndpoint endpoint) {
        this.mEndpoints.put(name, endpoint);
    }

    public boolean isValidForScopes(Set<String> scopes) {
        if (this.mIsValidForAllScopes) {
            return true;
        }
        return scopes.containsAll(scopes);
    }

    public void validForAllScopes() {
        this.mIsValidForAllScopes = true;
    }

    public ConfigEndpoint getEndpoint(String environment) {
        ConfigEndpoint configEndpoint = this.mEndpoints.containsKey(environment) ? this.mEndpoints.get(environment) : (this.mEndpoints.containsKey(DEVELOP) ? this.mEndpoints.get(DEVELOP) : this.mEndpoints.get("live"));
        return configEndpoint;
    }
}

