/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.http;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Headers
implements Iterable<String> {
    public static final String CONTENT_TYPE = "content-type";
    public static final String AUTHORIZATION = "authorization";
    public static final String USER_AGENT = "user-agent";
    public static final String ACCEPT_ENCODING = "accept-encoding";
    protected Map<String, String> mHeaders = new HashMap<String, String>();
    private Map<String, String> keyMapping = new HashMap<String, String>();

    @Override
    public Iterator<String> iterator() {
        return this.mHeaders.keySet().iterator();
    }

    public Headers header(String header, String value) {
        if (value != null && header != null) {
            value = header.equalsIgnoreCase(CONTENT_TYPE) ? value.toLowerCase() : value;
        }
        this.mHeaders.put(header, value);
        this.keyMapping.put(header != null ? header.toLowerCase() : null, header);
        return this;
    }

    public Headers headerIfNotPresent(String key, String value) {
        if (this.header(key) == null) {
            return this.header(key, value);
        }
        return this;
    }

    public Headers remove(String key) {
        this.mHeaders.remove(key);
        this.keyMapping.remove(key.toLowerCase());
        return this;
    }

    public String header(String key) {
        String caseKey = this.keyMapping.get(key.toLowerCase());
        if (caseKey != null) {
            return this.mHeaders.get(caseKey);
        }
        return null;
    }
}

