/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.http.serializer;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.paypal.http.HttpRequest;
import com.paypal.http.annotations.ListOf;
import com.paypal.http.exceptions.MalformedJsonException;
import com.paypal.http.exceptions.SerializeException;
import com.paypal.http.serializer.ObjectMapper;
import com.paypal.http.serializer.Serializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Json
implements Serializer {
    @Override
    public String contentType() {
        return "^application\\/json";
    }

    private boolean hasAncestor(Class descendant, Class ancestor) {
        List<Class<?>> interfaces;
        if (descendant == null) {
            return false;
        }
        if (ancestor.isInterface() && (interfaces = Arrays.asList(descendant.getInterfaces())).contains(ancestor)) {
            return true;
        }
        if (!descendant.equals(Object.class) && descendant.isAssignableFrom(ancestor)) {
            return true;
        }
        return this.hasAncestor(descendant.getSuperclass(), ancestor);
    }

    @Override
    public <T> T decode(String source, Class<T> cls) throws IOException {
        Gson gson = new GsonBuilder().create();
        if (this.hasAncestor(cls, List.class) && cls.getAnnotation(ListOf.class) != null) {
            ListOf listOf = cls.getAnnotation(ListOf.class);
            List deserialized = (List)gson.fromJson(source, new TypeToken<List<Map<String, Object>>>(){}.getType());
            try {
                T outlist = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Map map : deserialized) {
                    ((List)outlist).add(this.unmap(map, listOf.listClass()));
                }
                return outlist;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new UnsupportedEncodingException("Could not instantiate type " + cls.getSimpleName());
            }
        }
        if (this.hasAncestor(cls, List.class) || this.hasAncestor(cls, Map.class)) {
            try {
                return (T)gson.fromJson(source, cls);
            }
            catch (JsonSyntaxException e) {
                throw new MalformedJsonException("Malformed Json " + e.getMessage());
            }
        }
        try {
            Map deserialized = (Map)gson.fromJson(source, new TypeToken<Map<String, Object>>(){}.getType());
            return this.unmap(deserialized, cls);
        }
        catch (JsonSyntaxException e) {
            throw new MalformedJsonException("Malformed Json " + e.getMessage());
        }
    }

    private <T> T unmap(Map<String, Object> map, Class<T> destinationClass) throws IOException {
        try {
            return ObjectMapper.unmap(map, destinationClass);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedEncodingException("Could not instantiate type " + destinationClass.getSimpleName());
        }
        catch (RuntimeException re) {
            throw new MalformedJsonException("Unable to parse Json " + re.getMessage());
        }
    }

    @Override
    public byte[] encode(HttpRequest request) throws SerializeException {
        return this.serialize(request.requestBody()).getBytes(StandardCharsets.UTF_8);
    }

    public String serialize(Object o) throws SerializeException {
        Gson gson = new Gson();
        if (ObjectMapper.isModel(o)) {
            try {
                return gson.toJson(ObjectMapper.map(o));
            }
            catch (IllegalAccessException e) {
                throw new SerializeException(e.getMessage());
            }
        }
        return this.jsonValueStringFor(o);
    }

    private String jsonValueStringFor(Object obj) throws SerializeException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        if (obj == null || obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
            return gson.toJson(obj);
        }
        if (obj instanceof Object[] || obj instanceof Collection) {
            return gson.toJson(obj, new TypeToken<List<Object>>(){}.getType());
        }
        if (obj instanceof Map) {
            return gson.toJson(obj, new TypeToken<Map<String, Object>>(){}.getType());
        }
        if (ObjectMapper.isModel(obj)) {
            return this.serialize(obj);
        }
        throw new SerializeException(String.format("Object of class %s could not be serialized as json", obj.getClass()));
    }
}

