/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.braintreepayments.http.Environment;
import com.paypal.core.Authorization;
import java.util.Base64;

public class PayPalEnvironment
implements Authorization,
Environment {
    private String clientId;
    private String clientSecret;
    private String baseUrl;
    private String webUrl;

    public PayPalEnvironment(String clientId, String clientSecret, String baseUrl, String webUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.baseUrl = baseUrl;
        this.webUrl = webUrl;
    }

    @Override
    public String authorizationString() {
        return String.format("Basic %s", new String(Base64.getEncoder().encode((this.clientId + ":" + this.clientSecret).getBytes())));
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String webUrl() {
        return this.webUrl;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public int hashCode() {
        return (this.clientId + this.clientSecret).hashCode();
    }

    public static class Live
    extends PayPalEnvironment {
        public Live(String clientId, String clientSecret) {
            super(clientId, clientSecret, "https://api.paypal.com", "https://www.paypal.com");
        }
    }

    public static class Sandbox
    extends PayPalEnvironment {
        public Sandbox(String clientId, String clientSecret) {
            super(clientId, clientSecret, "https://api.sandbox.paypal.com", "https://www.sandbox.paypal.com");
        }
    }
}

