/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.orders;

import com.braintreepayments.http.HttpRequest;
import com.paypal.orders.Order;
import com.paypal.orders.OrderActionRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OrdersCaptureRequest
extends HttpRequest<Order> {
    public OrdersCaptureRequest(String orderId) {
        super("/v2/checkout/orders/{order_id}/capture?", "POST", Order.class);
        try {
            this.path(this.path().replace("{order_id}", URLEncoder.encode(String.valueOf(orderId), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.header("Content-Type", "application/json");
    }

    public OrdersCaptureRequest payPalClientMetadataId(String payPalClientMetadataId) {
        this.header("PayPal-Client-Metadata-Id", String.valueOf(payPalClientMetadataId));
        return this;
    }

    public OrdersCaptureRequest payPalRequestId(String payPalRequestId) {
        this.header("PayPal-Request-Id", String.valueOf(payPalRequestId));
        return this;
    }

    public OrdersCaptureRequest prefer(String prefer) {
        this.header("Prefer", String.valueOf(prefer));
        return this;
    }

    public OrdersCaptureRequest requestBody(OrderActionRequest orderActionRequest) {
        super.requestBody((Object)orderActionRequest);
        return this;
    }
}

