/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.object;

import com.braintreepayments.http.annotations.Model;
import com.braintreepayments.http.annotations.SerializedName;
import com.paypal.core.Authorization;
import java.util.Date;

@Model
public class AccessToken
implements Authorization {
    private final transient Date createDate = new Date();
    @SerializedName(value="access_token")
    private String accessToken;
    @SerializedName(value="token_type")
    private String tokenType = "Bearer";
    @SerializedName(value="expires_in")
    private Integer expiresIn;

    public boolean isExpired() {
        Date expireDate = new Date(this.createDate.getTime() + (long)(this.expiresIn * 1000));
        return new Date().after(expireDate);
    }

    public String accessToken() {
        return this.accessToken;
    }

    public String tokenType() {
        return this.tokenType;
    }

    public Integer expiresIn() {
        return this.expiresIn;
    }

    public Date createDate() {
        return this.createDate;
    }

    @Override
    public String authorizationString() {
        return String.format("Bearer %s", this.accessToken);
    }
}

