/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.orders;

import com.braintreepayments.http.HttpRequest;
import com.paypal.orders.AuthorizeRequest;
import com.paypal.orders.Order;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OrdersAuthorizeRequest
extends HttpRequest<Order> {
    public OrdersAuthorizeRequest(String orderId) {
        super("/v2/checkout/orders/{order_id}/authorize?", "POST", Order.class);
        try {
            this.path(this.path().replace("{order_id}", URLEncoder.encode(String.valueOf(orderId), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.header("Content-Type", "application/json");
    }

    public OrdersAuthorizeRequest authorization(String authorization) {
        this.header("Authorization", String.valueOf(authorization));
        return this;
    }

    public OrdersAuthorizeRequest contentType(String contentType) {
        this.header("Content-Type", String.valueOf(contentType));
        return this;
    }

    public OrdersAuthorizeRequest payPalAuthAssertion(String payPalAuthAssertion) {
        this.header("PayPal-Auth-Assertion", String.valueOf(payPalAuthAssertion));
        return this;
    }

    public OrdersAuthorizeRequest payPalClientMetadataId(String payPalClientMetadataId) {
        this.header("PayPal-Client-Metadata-Id", String.valueOf(payPalClientMetadataId));
        return this;
    }

    public OrdersAuthorizeRequest payPalRequestId(String payPalRequestId) {
        this.header("PayPal-Request-Id", String.valueOf(payPalRequestId));
        return this;
    }

    public OrdersAuthorizeRequest prefer(String prefer) {
        this.header("Prefer", String.valueOf(prefer));
        return this;
    }

    public OrdersAuthorizeRequest requestBody(AuthorizeRequest authorizeRequest) {
        super.requestBody((Object)authorizeRequest);
        return this;
    }
}

