/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.payments;

import com.paypal.http.HttpRequest;
import com.paypal.payments.Refund;
import com.paypal.payments.RefundRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class CapturesRefundRequest
extends HttpRequest<Refund> {
    public CapturesRefundRequest(String captureId) {
        super("/v2/payments/captures/{capture_id}/refund?", "POST", Refund.class);
        try {
            this.path(this.path().replace("{capture_id}", URLEncoder.encode(String.valueOf(captureId), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.header("Content-Type", "application/json");
    }

    public CapturesRefundRequest authorization(String authorization) {
        this.header("Authorization", String.valueOf(authorization));
        return this;
    }

    public CapturesRefundRequest payPalRequestId(String payPalRequestId) {
        this.header("PayPal-Request-Id", String.valueOf(payPalRequestId));
        return this;
    }

    public CapturesRefundRequest prefer(String prefer) {
        this.header("Prefer", String.valueOf(prefer));
        return this;
    }

    public CapturesRefundRequest requestBody(RefundRequest refundRequest) {
        super.requestBody((Object)refundRequest);
        return this;
    }
}

