/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.AuthorizationProvider;
import com.paypal.core.PayPalEnvironment;
import com.paypal.core.UserAgent;
import com.paypal.core.object.AccessToken;
import com.paypal.core.request.AccessTokenRequest;
import com.paypal.core.request.RefreshTokenRequest;
import com.paypal.http.Environment;
import com.paypal.http.HttpClient;
import com.paypal.http.HttpRequest;
import java.io.IOException;

public class PayPalHttpClient
extends HttpClient {
    private String refreshToken;

    public PayPalHttpClient(PayPalEnvironment environment) {
        super((Environment)environment);
        this.addInjector(this::addGzipHeader);
        this.addInjector(this::signRequest);
        this.addInjector(this::addFPTIHeaders);
    }

    public PayPalHttpClient(PayPalEnvironment environment, String refreshToken) {
        this(environment);
        this.refreshToken = refreshToken;
    }

    protected String getUserAgent() {
        return UserAgent.USER_AGENT;
    }

    private void signRequest(HttpRequest request) throws IOException {
        if (!this.hasAuthHeader(request) && !this.isAuthRequest(request)) {
            AccessToken accessToken = AuthorizationProvider.sharedInstance().authorize(this, this.refreshToken);
            request.header("authorization", accessToken.authorizationString());
        }
    }

    private void addFPTIHeaders(HttpRequest request) throws IOException {
        request.header("sdk_name", "Checkout SDK");
        request.header("sdk_version", "1.0.5");
        request.header("sdk_tech_stack", "Java " + System.getProperty("java.version"));
        request.header("api_integration_type", "PAYPALSDK");
    }

    private void addGzipHeader(HttpRequest request) throws IOException {
        request.headers().headerIfNotPresent("accept-encoding", "gzip");
    }

    private boolean isAuthRequest(HttpRequest request) {
        return request instanceof AccessTokenRequest || request instanceof RefreshTokenRequest;
    }

    private boolean hasAuthHeader(HttpRequest request) {
        return request.headers().header("authorization") != null;
    }

    PayPalEnvironment getPayPalEnvironment() {
        return (PayPalEnvironment)super.getEnvironment();
    }
}

