package urn.ebay.apis.eBLBaseComponents;
import urn.ebay.apis.eBLBaseComponents.AckCodeType;
import java.util.List;
import java.util.ArrayList;
import urn.ebay.apis.eBLBaseComponents.ErrorType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import java.io.FileInputStream;
import java.io.StringReader;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Base type definition of a response payload that can carry
 * any type of payload content with following optional
 * elements: - timestamp of response message, - application
 * level acknowledgement, and - application-level errors and
 * warnings. 
 */
public class AbstractResponseType{


	/**
	 * This value represents the date and time (GMT) when the
	 * response was generated by a service provider (as a result of
	 * processing of a request). 
	 
	 */ 
	private String timestamp;

	/**
	 * Application level acknowledgement code. 
	 
	 */ 
	private AckCodeType ack;

	/**
	 * CorrelationID may be used optionally with an application
	 * level acknowledgement. 
	 
	 */ 
	private String correlationID;

	/**
	 * 
	 
	 */ 
	private List<ErrorType> errors = new ArrayList<ErrorType>();

	/**
	 * This refers to the version of the response payload schema. 
	 
	 */ 
	private String version;

	/**
	 * This refers to the specific software build that was used in
	 * the deployment for processing the request and generating the
	 * response. 
	 
	 */ 
	private String build;

	

	/**
	 * Default Constructor
	 */
	public AbstractResponseType (){
	}	

	/**
	 * Getter for timestamp
	 */
	 public String getTimestamp() {
	 	return timestamp;
	 }
	 
	/**
	 * Setter for timestamp
	 */
	 public void setTimestamp(String timestamp) {
	 	this.timestamp = timestamp;
	 }
	 
	/**
	 * Getter for ack
	 */
	 public AckCodeType getAck() {
	 	return ack;
	 }
	 
	/**
	 * Setter for ack
	 */
	 public void setAck(AckCodeType ack) {
	 	this.ack = ack;
	 }
	 
	/**
	 * Getter for correlationID
	 */
	 public String getCorrelationID() {
	 	return correlationID;
	 }
	 
	/**
	 * Setter for correlationID
	 */
	 public void setCorrelationID(String correlationID) {
	 	this.correlationID = correlationID;
	 }
	 
	/**
	 * Getter for errors
	 */
	 public List<ErrorType> getErrors() {
	 	return errors;
	 }
	 
	/**
	 * Setter for errors
	 */
	 public void setErrors(List<ErrorType> errors) {
	 	this.errors = errors;
	 }
	 
	/**
	 * Getter for version
	 */
	 public String getVersion() {
	 	return version;
	 }
	 
	/**
	 * Setter for version
	 */
	 public void setVersion(String version) {
	 	this.version = version;
	 }
	 
	/**
	 * Getter for build
	 */
	 public String getBuild() {
	 	return build;
	 }
	 
	/**
	 * Setter for build
	 */
	 public void setBuild(String build) {
	 	this.build = build;
	 }
	 



	private  boolean isWhitespaceNode(Node n) {
		if (n.getNodeType() == Node.TEXT_NODE) {
			String val = n.getNodeValue();
			return val.trim().length() == 0;
		} else if (n.getNodeType() == Node.ELEMENT_NODE ) {
			return (n.getChildNodes().getLength() == 0);
		} else {
			return false;
		}
	}
	
	public AbstractResponseType(Node node) throws XPathExpressionException {
		XPathFactory factory = XPathFactory.newInstance();
		XPath xpath = factory.newXPath();
		Node childNode = null;
		NodeList nodeList = null;
		childNode = (Node) xpath.evaluate("Timestamp", node, XPathConstants.NODE);
		if (childNode != null && !isWhitespaceNode(childNode)) {
		    this.timestamp = childNode.getTextContent();
		}
	
		childNode = (Node) xpath.evaluate("Ack", node, XPathConstants.NODE);
		if (childNode != null && !isWhitespaceNode(childNode)) {
		    this.ack = AckCodeType.fromValue(childNode.getTextContent());
		}
		childNode = (Node) xpath.evaluate("CorrelationID", node, XPathConstants.NODE);
		if (childNode != null && !isWhitespaceNode(childNode)) {
		    this.correlationID = childNode.getTextContent();
		}
	
        nodeList = (NodeList) xpath.evaluate("Errors", node, XPathConstants.NODESET);
		if (nodeList != null && nodeList.getLength() > 0) {
			for(int i=0; i < nodeList.getLength(); i++) {
				Node subNode = nodeList.item(i);
				this.errors.add(new ErrorType(subNode));
			}
		}
		childNode = (Node) xpath.evaluate("Version", node, XPathConstants.NODE);
		if (childNode != null && !isWhitespaceNode(childNode)) {
		    this.version = childNode.getTextContent();
		}
	
		childNode = (Node) xpath.evaluate("Build", node, XPathConstants.NODE);
		if (childNode != null && !isWhitespaceNode(childNode)) {
		    this.build = childNode.getTextContent();
		}
	
	}
 
}