package urn.ebay.api.PayPalAPI;
import urn.ebay.apis.eBLBaseComponents.AbstractResponseType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import java.io.FileInputStream;
import java.io.StringReader;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 *  A timestamped token by which you identify to PayPal that you
 *  are processing this payment with Express Checkout. The token
 *  expires after three hours. If you set Token in the
 *  SetExpressCheckoutRequest, the value of Token in the
 *  response is identical to the value in the request. Character
 *  length and limitations: 20 single-byte characters
 */
public class SetExpressCheckoutResponseType extends AbstractResponseType {


	/**
	*  A timestamped token by which you identify to PayPal that you
	*  are processing this payment with Express Checkout. The token
	*  expires after three hours. If you set Token in the
	*  SetExpressCheckoutRequest, the value of Token in the
	*  response is identical to the value in the request. Character
	*  length and limitations: 20 single-byte characters	 
	 */ 
	private String token;

	

	/**
	 * Default Constructor
	 */
	public SetExpressCheckoutResponseType (){
	}	

	/**
	 * Getter for token
	 */
	 public String getToken() {
	 	return token;
	 }
	 
	/**
	 * Setter for token
	 */
	 public void setToken(String token) {
	 	this.token = token;
	 }
	 



	private  boolean isWhitespaceNode(Node n) {
		if (n.getNodeType() == Node.TEXT_NODE) {
			String val = n.getNodeValue();
			return val.trim().length() == 0;
		} else if (n.getNodeType() == Node.ELEMENT_NODE ) {
			return (n.getChildNodes().getLength() == 0);
		} else {
			return false;
		}
	}
	
	public SetExpressCheckoutResponseType(Node node) throws XPathExpressionException {
		super(node);
		XPathFactory factory = XPathFactory.newInstance();
		XPath xpath = factory.newXPath();
		Node childNode = null;
		NodeList nodeList = null;
		childNode = (Node) xpath.evaluate("Token", node, XPathConstants.NODE);
		if (childNode != null && !isWhitespaceNode(childNode)) {
		    this.token = childNode.getTextContent();
		}
	
	}
 
}