/*
 * Decompiled with CFR 0.152.
 */
package urn.ebay.apis.eBLBaseComponents;

import com.paypal.core.SDKUtil;
import java.math.BigDecimal;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import urn.ebay.apis.CoreComponentTypes.BasicAmountType;
import urn.ebay.apis.eBLBaseComponents.RedeemedOfferType;

public class DiscountInfoType {
    private static final String nameSpace = "urn:ebay:apis:eBLBaseComponents";
    private static final String preferredPrefix = "ebl";
    private String name;
    private String description;
    private BasicAmountType amount;
    private RedeemedOfferType redeemedOfferType;
    private String redeemedOfferId;
    private BigDecimal pointsAccrued;

    public DiscountInfoType() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BasicAmountType getAmount() {
        return this.amount;
    }

    public void setAmount(BasicAmountType amount) {
        this.amount = amount;
    }

    public RedeemedOfferType getRedeemedOfferType() {
        return this.redeemedOfferType;
    }

    public void setRedeemedOfferType(RedeemedOfferType redeemedOfferType) {
        this.redeemedOfferType = redeemedOfferType;
    }

    public String getRedeemedOfferId() {
        return this.redeemedOfferId;
    }

    public void setRedeemedOfferId(String redeemedOfferId) {
        this.redeemedOfferId = redeemedOfferId;
    }

    public BigDecimal getPointsAccrued() {
        return this.pointsAccrued;
    }

    public void setPointsAccrued(BigDecimal pointsAccrued) {
        this.pointsAccrued = pointsAccrued;
    }

    public String toXMLString(String prefix, String name) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            if (prefix != null) {
                sb.append("<").append(prefix).append(":").append(name).append(">");
            } else {
                sb.append("<").append(preferredPrefix).append(":").append(name).append(">");
            }
        }
        if (this.description != null) {
            sb.append("<").append(preferredPrefix).append(":Description>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.description));
            sb.append("</").append(preferredPrefix).append(":Description>");
        }
        if (this.amount != null) {
            sb.append("<").append(preferredPrefix).append(":Amount>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.amount.getValue()));
            sb.append("</").append(preferredPrefix).append(":Amount>");
        }
        if (this.redeemedOfferType != null) {
            sb.append("<").append(preferredPrefix).append(":RedeemedOfferType>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.redeemedOfferType.getValue()));
            sb.append("</").append(preferredPrefix).append(":RedeemedOfferType>");
        }
        if (this.redeemedOfferId != null) {
            sb.append("<").append(preferredPrefix).append(":RedeemedOfferId>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.redeemedOfferId));
            sb.append("</").append(preferredPrefix).append(":RedeemedOfferId>");
        }
        if (this.pointsAccrued != null) {
            sb.append("<").append(preferredPrefix).append(":pointsAccrued>").append(SDKUtil.escapeInvalidXmlCharsRegex((String)this.pointsAccrued.toString()));
            sb.append("</").append(preferredPrefix).append(":pointsAccrued>");
        }
        return sb.toString();
    }

    private boolean isWhitespaceNode(Node n) {
        if (n.getNodeType() == 3) {
            String val = n.getNodeValue();
            return val.trim().length() == 0;
        }
        if (n.getNodeType() == 1) {
            return n.getChildNodes().getLength() == 0;
        }
        return false;
    }

    public DiscountInfoType(Node node) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Node childNode = null;
        Object nodeList = null;
        childNode = (Node)xpath.evaluate("Name", node, XPathConstants.NODE);
        if (childNode != null && !this.isWhitespaceNode(childNode)) {
            this.name = childNode.getTextContent();
        }
        if ((childNode = (Node)xpath.evaluate("Description", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.description = childNode.getTextContent();
        }
        if ((childNode = (Node)xpath.evaluate("Amount", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.amount = new BasicAmountType(childNode);
        }
        if ((childNode = (Node)xpath.evaluate("RedeemedOfferType", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.redeemedOfferType = RedeemedOfferType.fromValue(childNode.getTextContent());
        }
        if ((childNode = (Node)xpath.evaluate("RedeemedOfferId", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.redeemedOfferId = childNode.getTextContent();
        }
        if ((childNode = (Node)xpath.evaluate("PointsAccrued", node, XPathConstants.NODE)) != null && !this.isWhitespaceNode(childNode)) {
            this.pointsAccrued = new BigDecimal(childNode.getTextContent());
        }
    }
}

